<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>User<?= $this->endSection() ?>

<?= $this->section("content") ?>

<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Suppliers",
        "controller" => "Suppliers",
        "links" => [
            "Users' List" =>  ["url" => url_to("Users::index"), "auth_check" => true],
            "Edit User" =>  ["url" => url_to("Users::edit", $user->id), "auth_check" => true],
            "Reset Password" =>  ["url" => url_to("Password::reset", $user->id), "auth_check" => true]
        ]
    ]
) ?>

<div class="round-border">

    <h1>User</h1>

    <dl>
        <dt>email</dt>
        <dd><?= esc($user->email) ?></dd>

        <dt>User Name</dt>
        <dd><?= esc($user->username) ?></dd>

        <dt>Is Admin?</dt>
        <dd><?= $user->inGroup('admin') ? 'Yes' : 'No' ?></dd>

        <dt>Created</dt>
        <dd><?= $user->created_at->humanize() ?></dd>

    </dl>



    <a href="<?= url_to("Users::confirmDelete", $user->id) ?>"><button style="background-color: red;">Delete</button></a>

</div>

<?= $this->endSection() ?>