<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>New User<?= $this->endSection() ?>

<?= $this->section("content") ?>

<?= view(
    "layouts/bcr-nav",
    [
        "title" => "New User",
        "controller" => "Users",
        "links" => [
            "Users' List" =>  ["url" => base_url("users"), "auth_check" => false]
        ]
    ]
) ?>

    <?= form_open("users") ?>

<div class="round-border">

    <label for="email">Email</label>
    <input type="email" id="email" name="email"  value="<?= old("email", $user->email) ?>">

    <label for="username">User Name</label>
    <input type="text" name="username" id="username"  value="<?= old("username", $user->username) ?>">

    <label for="password">Password</label>
    <input type="password" name="password" id="password"  value="<?= old("password", $user->password) ?>">

    <label for="password_confirmation">Confirm Password</label>
    <input type="password" name="password_confirmation" id="password_confirmation"  value="<?= old("password_confirmation", $user->password_confirmation) ?>">

    <label for="usergroup">User Group</label>
    <select name="usergroup" id="usergroup">
        <option value="user" selected >User</option>
        <option value="admin">Admin</option>
    </select>    

    <button class="button" type="submit">Save</button>
    <a class="button" href="<?= site_url('/users') ?>" default>Cancel</a>
</div>
    </form>

<?= $this->endSection() ?>

