<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>Users<?= $this->endSection() ?>

<?= $this->section("header") ?>
    <link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
    <link rel="stylesheet" href="<?= base_url('/js/tabulator-master/dist/css/tabulator_simple.css') ?>" />
    
    <script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"></script>
    <script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"></script>
    <script type='text/javascript' src="<?= base_url('/js/luxon.min.js') ?>"></script>
    <script type='text/javascript' src="<?= base_url('/js/tabulator-master/dist/js/tabulator.min.js') ?>"></script>
<?= $this->endSection() ?>

<?= $this->section("content") ?>


<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Users",
        "controller" => "Users",
        "links" => [
            "New" =>  ["url" => url_to("Users::new"), "auth_check" => true]
        ]
    ]
) ?>

<div class="round-border">
    <div id="wrapper"></div>
</div>
<script type='text/javascript'>

    new Tabulator('#wrapper',{

        data: [
            <?php foreach($users as $user): ?>
            <?="{" ?>
            <?="id:$user->id," ?>
            <?="username:'$user->username'," ?>
            <?="email:'$user->email'," ?>
            <?= $user->inGroup('admin') ? "isadmin:true," : "isadmin:false," ?>
            <?="}," ?>
            <?= chr(13).chr(10) ?>
            <?php endforeach; ?>
        ],
            layout:"fitDataStretch",
            // responsiveLayout:"hide",
            pagination: true, //"local",
            paginationSize: 25,
            tooltips: true,
            columns: [{
                    title: "id",
                    field: "id",
                    sorter: "number",
                    height: "100%",
                    width: 150,
                    visible: false,
                }, {
                    title: "User Name",
                    field: "username",
                    sorter: "string",
                    hozAlign: "left",
                    width: 120,
                    headerFilter:"input", 
                    headerFilterParams:{valuesLookup:true, clearable:true},
                    responsive:0,
                },
                {
                    title: "Email",
                    field: "email",
                    sorter: "string",
                    hozAlign: "left",
                    width: 200,
                    headerFilter:"input", 
                    responsive:0,
                    //headerFilterParams:{valuesLookup:true, clearable:true},
                }, {
                    title: "Is Admin",
                    field: "isadmin",
                    sorter: "boolean",
                    hozAlign: "left",
                    width: 120,
                    formatter:"tickCross",
                    //headerFilter:"list", 
                    responsive:0,
                    //headerFilterParams:{valuesLookup:true, clearable:true},
                }, 
            ],
        }).on('rowClick', function(e, row){
            window.location = '<?= base_url("users")."/"?>' + row.getCell('id').getValue() + '/edit';
        });
    </script>

<?= $this->endSection() ?>
