<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>Edit User<?= $this->endSection() ?>

<?= $this->section("header") ?>
<script type="text/javascript" src="<?php echo base_url('js/jquery/jquery-3.7.1.min.js'); ?>"></script>
<script type="text/javascript" src="<?php echo base_url('js/jquery-ui-1.14.1/jquery-ui.min.js'); ?>"></script>
<?= $this->endSection() ?>

<?= $this->section("content") ?>


<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Edit User",
        "controller" => "Users",
        "links" => [
            "Users' List" =>  ["url" => base_url("users"), "auth_check" => true],
            "Reset Password" =>  ["url" => url_to("Password::reset", $user->id), "auth_check" => true]
        ]
    ]
) ?>



<div class="round-border">

    <?= form_open("users/" . $user->id) ?>

    <input type="hidden" name="_method" value="PATCH">

    <label for="email">Email</label>
    <input type="email" id="email" name="email" value="<?= old("User", esc($user->email)) ?>">

    <label for="username">User Name</label>
    <input type="text" name="username" id="username" value="<?= old("User", $user->username) ?>">

    <label for="usergroup">User Group</label>
    <?php if ($user->id === auth()->user()->id): ?>
        <input type="text" name="usergroup" id="usergroup" value="admin" disabled>
    <?php else: ?>
        <select name="usergroup" id="usergroup" onchange="showhideaccesslevels();">
            <option value="user" <?= $user->inGroup("admin") ? '' : 'selected' ?>>User</option>
            <option value="admin" <?= $user->inGroup("admin") ? 'selected' : '' ?>>Admin</option>
        </select>
    <?php endif; ?>

    <div id='access_levels'>
        <table>
            <tr>
                <th>Access Area</th>
                <th>Can Access</th>
                <th>Can Edit</th>
                <th></th>
                <th></th>
            </tr>
            <tr>
                <td></td>
                <td>All<input type="checkbox" name="checkAll" id="checkAllAccess"></td>
                <td>All<input type="checkbox" name="checkAll" id="checkAllEdit"></td>
                <td></td>
                <td></td>
            </tr>
            <?php foreach ($user_access_levels as $user_access_level) : ?>

                <tr>
                    <td>
                        <?= $user_access_level->access_level ?>
                    </td>
                    <td>
                        <input class="checkAccess" type="checkbox" name="can_access_<?= $user_access_level->ualid ?>" id="can_access_<?= $user_access_level->ualid ?>" value="1" <?= $user_access_level->can_access == 1 ? 'checked' : '' ?>>
                    </td>
                    <td>
                        <input class="checkEdit" type="checkbox" name="can_edit_<?= $user_access_level->ualid ?>" id="can_edit_<?= $user_access_level->ualid ?>" value="1" <?= $user_access_level->can_edit == 1 ? 'checked' : '' ?>>
                    </td>
                    <td>
                        <?= form_hidden("ualid_$user_access_level->ualid", "$user_access_level->ualid") ?>
                    </td>
                    <td>
                        <?= form_hidden("uaid_$user_access_level->ualid", "$user_access_level->uaid") ?>
                    </td>
                </tr>
            <?php endforeach ?>
        </table>
    </div>

    <button class="button" type="submit">Save</button>
    <a class="button" href="<?= site_url('/users') ?>" default>Cancel</a>

</div>

</form>

<script type="text/javascript">
    $("#checkAllAccess").click(function() {
        $('.checkAccess').prop('checked', this.checked);
    });

    $("#checkAllEdit").click(function() {
        $('.checkEdit').prop('checked', this.checked);
    });

    function showhideaccesslevels() {
        var val = $('#usergroup').val(); // document.getElementById('#usergroup').value;
        if (val == 'admin') {
            $('#access_levels').css('display', 'none');
            // document.getElementById(access_levels).style.visibility = 'hidden';
        } else {
            $('#access_levels').css('display', 'block');
            //            document.getElementById(access_levels).style.visibility = 'visible';     // Show
        }
    }

    $(document).ready(() => {
        showhideaccesslevels();
    });
</script>

<?= $this->endSection() ?>