<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>Template<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"></script>
<link rel="stylesheet" href="<?= base_url('/js/select2/dist/css/select2.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/select2/dist/js/select2.min.js') ?>"></script>
<link rel="stylesheet" href="<?= base_url('/css/templates.css') . '?' . rand() ?>" />

<script type='text/javascript'>
    $(document).ready(function() {
        $('.select2').select2();
    });
    $(function() {
        var focusedElement;
        $(document).on('focus', 'input', function() {
            if (focusedElement == this) return; //already focused, return so user can now place cursor at specific point in input.
            focusedElement = this;
            setTimeout(function() {
                focusedElement.select();
            }, 100); //select all text in any field on focus for easy re-entry. Delay sightly to allow focus to "stick" before selecting.
        });
    });
</script>

<?= $this->endSection() ?>

<?= $this->section("content") ?>

<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Template",
        "controller" => "Templates",
        "links" => [
            "Templates' List" =>  ["url" => url_to("Templates::index"), "auth_check" => true],
            "New" =>  ["url" => url_to("Templates::new"), "auth_check" => true],
        ]
    ]
) ?>

<div class="round-border">

    <div id="templates-outer" style="display: grid; gap:1rem; grid-template-columns:1fr;">

        <div style="display: grid; row-gap: 1rem; grid-template-columns:1fr">
            <div id="templates-heading"><?= $template->TemplateName ?></div>
        </div>
        <div id="templates-main">

            <?= $this->include("Templates/showheader") ?>

            <div id="templates-main-edit" style="display: grid; gap: 1rem; grid-template-columns:repeat(2,1fr);">
                <a class="button" href="<?= url_to("Templates::edit", $template->TemplateID) ?>">Edit</a>

                <a class="button" style="background-color: red;" href="<?= url_to("Templates::confirmDelete", $template->TemplateID) ?>">Delete</a>
            </div>
        </div>

        <div id="templates-inputs">
            <?= form_open("templateinputs/" . $template->TemplateID) ?>
            <div id="templates-inputs-add"
                style="display: grid; gap: 1rem; grid-template-columns:70px 250px 150px 100px 180px;">

                <label for="InputID" title="Alt+I"><u><b>I</b></u>nput</label>
                <select class="select2" name="InputID" id="InputID" accesskey="I" title="Alt+I">
                    <?php $currentinputype = 0; ?>
                    <?php foreach ($inputs as $input): ?>
                        <?php if ($input->InputTypeID !== $currentinputype): ?>
                            <?php if ($currentinputype > 0): ?>
                                </optgroup>
                            <?php endif; ?>
                            <?php $currentinputype = $input->InputTypeID; ?>
                            <optgroup label="<?= $input->InputType ?>">
                                <option value="<?= $input->InputID ?>">
                                    <?= $input->InputName ?>
                                </option>
                            <?php else: ?>
                                <option value="<?= $input->InputID ?>">
                                    <?= $input->InputName ?>
                                </option>
                            <?php endif; ?>
                        <?php endforeach; ?>
                            </optgroup>
                </select>

                <label for="Qty" title="Alt+Q"><u><b>Q</b></u>ty (grams or each)</label>
                <input type="number" name="Qty" id="Qty" value="1" accesskey="Q" title="Alt+Q">
                <button class="button" type="submit" accesskey="A" title="Alt+A"><u><b>A</b></u>dd Input</button>
            </div>
            </form>

            <?php $template->showRemove = true; ?>
            <?= $this->include("Templates/showinputs") ?>

            <div>
            </div>
        </div>
        <?= $this->endSection() ?>