<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Templates<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<link rel="stylesheet" href="<?= base_url('/js/tabulator-master/dist/css/tabulator_simple.css') ?>" />

<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/luxon.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/tabulator-master/dist/js/tabulator.min.js') ?>"> </script>
<style>
	.tabulator-row.tabulator-selectable:hover {
		background-color: #bbb !important;
	}
</style>
<?= $this->endSection() ?>

<?= $this->section("content") ?>

<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Templates",
        "controller" => "Templates",
        "links" => [
            "New" =>  ["url" => url_to("Templates::new"), "auth_check" => true]
        ]
    ]
) ?>

<?= view("layouts/tabulatorgrid") ?>


<script type='text/javascript'>
	//$rowHoverBackground = #ffffff;

	new Tabulator('#wrapper', {
		data: [
			<?php foreach ($templates as $template): ?>
			<?= "{" ?>
			<?= "TemplateID:$template->TemplateID," ?>
			<?= "TemplateName:'".addslashes($template->TemplateName)."'," ?>
			<?= "lastupdated:'$template->lastupdated'," ?>
			<?= "updatedby:'$template->username'," ?>
			<?= "}," ?>
			<?= chr(13) . chr(10) ?>
			<?php endforeach; ?>
		],
		layout: "fitDataStretch",
		pagination: false,
		tooltips: true,
		columns: [{
				title: "TemplateID",
				field: "TemplateID",
				sorter: "number",
				width: 150,
				visible: false,
			}, {
				title: "Template Name",
				field: "TemplateName",
				sorter: "string",
				hozAlign: "left",
				width: 200,
				headerFilter: "input",
			}, {
				title: "Record Updated",
				field: "lastupdated",
				sorter: "datetime",
				hozAlign: "left",
				width: 150,
				formatter: "datetime",
				formatterParams: {
					inputFormat: "yyyy-LL-dd TT",
					outputFormat: "dd/MM/yyyy TT",
					invalidPlaceholder: "(invalid date)",
					timezone: "system",
				}
			}, {
				title: "Updated By",
				field: "updatedby",
				sorter: "string",
				hozAlign: "left",
				width: 200,
				headerFilter: "list",
				headerFilterParams: {
					valuesLookup: true,
					clearable: true
				},
			}, ],
	}).on('cellClick', function(e, cell) {
		window.location = '<?= base_url("templates") . "/" ?>' + cell.getRow().getCell('TemplateID').getValue();
	});
</script>

<?= $this->endSection() ?>

<?= $this->section("javascript") ?>
<?= $this->endSection() ?>