<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Roast Colours<?= $this->endSection() ?>
<?= $this->section("content") ?>


<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Agtron Numbers",
        "controller" => "RoastColours",
        "links" => [
            "New" =>  ["url" => url_to("RoastColours::new"), "auth_check" => true]
        ]
    ]
) ?>

<div class="index-div">
    <table>
        <tr>
            <th></th>
            <th>ID</th>
            <th>Roast Colour</th>
            <th>From Agtron Number</th>
            <th>To Agtron Number</th>
            <th>Last Updated</th>
            <th>Updated By</th>

            <?php foreach ($roastcolours as $roastcolour): ?>
        <tr>
            <td>
                <a href="<?= site_url('/RoastColours/' . $roastcolour->RoastColourID) ?>">
                    <button>View</button>
                </a>
            </td>
            <td>
                <?= $roastcolour->RoastColourID ?>
            </td>
            <td>
                <?= esc($roastcolour->RoastColourName) ?>
            </td>
            <td>
                <?= esc($roastcolour->FromNumber) ?>
            </td>
            <td>
                <?= esc($roastcolour->ToNumber) ?>
            </td>
            <td>
                <?= $roastcolour->lastupdated ?>
            </td>
            <td>
                <?= esc($roastcolour->username) ?>
            </td>
        </tr>
    <?php endforeach; ?>


    </table>
</div>
<?= $this->endSection() ?>