
<input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

<div id="recipes-inputs-colheader" style="display: grid; gap: 1rem; grid-template-columns:30px repeat(5,1fr);">
    <div></div>
    <div class="recipes-input-inputname">Product Name</div>
    <div class="recipes-input-certificate">Certificate</div>
    <div class="recipes-input-cost">Per Kg</div>
    <div class="recipes-input-qty">Grams or Ea</div>
    <div class="recipes-input-inputcost">Cost</div>
</div>

<?php $inputcss = 'recipes-inputs-odd'; ?>
<div id="recipes-inputs-data" style="display: grid; row-gap: 0.35rem; grid-template-columns:40px repeat(5,1fr);">
    <?php $total = 0.0; ?>
    <?php $subtotalweight = 0; ?>
    <?php $subtotalcost = 0.0; ?>
    <?php $currentinputtypeid = 0; ?>
    <?php $iscoffee = 0; ?>
    <?php foreach ($recipeinputs as $recipeinput): ?>
        <?php
        if ($recipeinput->InputTypeID != $currentinputtypeid) {
            if($currentinputtypeid > 0){
                if( (int)$iscoffee == 1){
                    if((int)(($recipe->PackQty)*(1 + ($recipe->WastePercent / 100))) == (int)$subtotalweight){
                        $fontcolour = '#000000';
                        $bordercolour = $recipe->HeaderColour;
                    }else{
                        $fontcolour = '#DC143C';
                        $bordercolour = '#DC143C';
                    }
                }else{
                    $fontcolour = '#000000';
                    $bordercolour = $recipe->HeaderColour;
                }
                echo "<div class='recipes-inputtypes' style='grid-column: 4;
                background-color:$recipe->BodyColour; border-style:solid;
                border-color:$recipe->HeaderColour; border-width:0.5px; text-align:center;'>Sub Totals</div>";
                echo "<div class='recipes-inputtypes' style='grid-column: 5;
                color:$fontcolour;
                background-color:$recipe->BodyColour; border-style:solid;
                border-color:$bordercolour; border-width:0.5px; text-align:right;'>$subtotalweight</div>";
                echo "<div class='recipes-inputtypes' style='grid-column: 6;
                background-color:$recipe->BodyColour; border-style:solid;
                border-color:$recipe->HeaderColour; border-width:0.5px; text-align:right;'>£ ".number_format($subtotalcost,2)."</div>";
                $subtotalcost = 0.0;
                $subtotalweight = 0;
            }
            $currentinputtypeid = $recipeinput->InputTypeID;
            $iscoffee = $recipeinput->IsCoffee;
            echo "<div class='recipes-inputtypes' style='grid-column: 1 / span 6;
                    background-color:$recipe->BodyColour; border-style:solid;
                    border-color:$recipe->HeaderColour; border-width:0.5px;'>$recipeinput->InputType</div>";
        }
        ?>
        <div>
            <?php if ($recipe->showRemove): ?>
                <a class="recipes-remove-input" title="DELETE line" href="<?= site_url('/recipeinputs/') . $recipe->RecipeID . '/' . $recipeinput->RecipeInputID . '/delete' ?>">X</a>
            <?php else: ?>
                <div></div>
            <?php endif; ?>
        </div>
        <div class="<?= $inputcss ?> recipes-input-inputname">
            <a href="<?= base_url("inputs/$recipeinput->InputID") ?>"><?= $recipeinput->InputName ?></a>
        </div>
        <div class="<?= $inputcss ?> recipes-input-certification">
            <?= esc($recipeinput->Certification) ?>
        </div>
        <div class="<?= $inputcss ?> recipes-input-cost">
            <a  id="<?= $recipeinput->InputID ?>" href="#" onclick="openNav(this);">£ <?= number_format($recipeinput->Cost, 2) ?></a>
        </div>
        <div class="<?= $inputcss ?> recipes-input-qty">
            <?= number_format($recipeinput->Qty, 0) ?>
        </div>
        <div class="<?= $inputcss ?> recipes-input-inputcost">
            £ <?= number_format($recipeinput->InputCost, 2) ?>
            <?php $total += (float)$recipeinput->InputCost; ?>
        </div>
        <?php
            $subtotalcost += (float)$recipeinput->InputCost;
            $subtotalweight += (int)$recipeinput->Qty;
            $inputcss == 'recipes-inputs-odd' ? $inputcss = 'recipes-inputs-even' : $inputcss = 'recipes-inputs-odd';
        ?>
    <?php endforeach;

    echo "<div class='recipes-inputtypes' style='grid-column: 4;
                background-color:$recipe->BodyColour; border-style:solid;
                border-color:$recipe->HeaderColour; border-width:0.5px; text-align:center;'>Sub Totals</div>";

    echo "<div class='recipes-inputtypes' style='grid-column: 5;
                background-color:$recipe->BodyColour; border-style:solid;
                border-color:$recipe->HeaderColour; border-width:0.5px; text-align:right;'>$subtotalweight</div>";
    echo "<div class='recipes-inputtypes' style='grid-column: 6;
                background-color:$recipe->BodyColour; border-style:solid;
                border-color:$recipe->HeaderColour; border-width:0.5px; text-align:right;'>£ ".number_format($subtotalcost,2)."</div>";
    $subtotalcost = 0.0;
    $subtotalweight = 0;
    ?>
</div>

<div id="recipes-summary" style="display: grid; gap: 1rem; grid-template-columns:30px repeat(5,1fr); background-color:<?= $recipe->FooterColour ?>">
    <div></div>
    <div><b>Total Cost</b></div>
    <div></div>
    <div></div>
    <div></div>
    <div class="recipes-input-cost"
        style="background-color:<?= $recipe->FooterColour ?>; border-style:solid;
                border-color:<?= $recipe->HeaderColour ?>; border-width:0.5px;font-weight: bold;">£
        <?= number_format($total, 2) ?></div>

    <div></div>
    <div><b>Annual Kg</b></div>
    <div></div>
    <div></div>
    <div></div>
    <div class="recipes-input-cost" style="font-weight: bold;"><?= number_format($recipe->AnnualKg, 2) ?></div>


    <div></div>
    <div><b>Sell Price per Unit</b></div>
    <div></div>
    <div></div>
    <div></div>
    <div class="recipes-input-cost" style="font-weight: bold;">£ <?= number_format($recipe->SellPriceKg, 2) ?></div>

    <div></div>
    <div><b>GP£</b></div>
    <div></div>
    <div></div>
    <div></div>
    <div class="recipes-input-cost" style="font-weight: bold;">£ <?php echo number_format($recipe->SellPriceKg > 0 ? $recipe->SellPriceKg - $total : 0.0, 2); ?></div>

    <div></div>
    <div><b>GPM(%)</b></div>
    <div></div>
    <div></div>
    <div></div>
    <div class="recipes-input-cost" style="font-weight: bold;"><?php echo number_format($recipe->SellPriceGP,2) . '%'; ?></div>
    <!-- <div class="recipes-input-cost" style="font-weight: bold;"><?php echo number_format(($recipe->SellPriceKg > 0 ? ($recipe->SellPriceKg - $total) / $recipe->SellPriceKg : 0.0) * 100, 0) . '%'; ?></div> -->

</div>