<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>Recipe<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"> </script>
<link rel="stylesheet" href="<?= base_url('/js/select2/dist/css/select2.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/select2/dist/js/select2.min.js') ?>"> </script>
<link rel="stylesheet" href="<?= base_url('/css/recipes.css') . '?' . rand() ?>" />
<link href="<?= base_url('js/lightbox2/dist/css/lightbox.css') ?>" rel="stylesheet" />
<link rel="stylesheet" href="<?= base_url('css/overlay.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js'); ?>"></script>
<link rel="stylesheet" href="<?= base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">
<script type='text/javascript' src="<?= base_url('/js/htmx/htmx.min.js'); ?>"></script>
<script type='text/javascript'>
	$(document).ready(function() {
		$('.select2').select2();
	});
	$(function() {
		var focusedElement;
		$(document).on('focus', 'input', function() {
			if (focusedElement == this)
				return; //already focused, return so user can now place cursor at specific point in input.
			focusedElement = this;
			setTimeout(function() {
				focusedElement.select();
			}, 100); //select all text in any field on focus for easy re-entry. Delay sightly to allow focus to "stick" before selecting.
		});
	});
</script>

<?= $this->endSection() ?>

<?= $this->section("content") ?>

<div id="myNav" class="overlay">
	<a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
	<div class="overlay-content">
		<div style="border-style:solid; border-width:2px; border-radius:5px; border-color:#818181; font-size: 36px !important;color: #818181 !important; margin: 0 10vw;">
			<div style="display:grid; grid-template-columns:repeat(2,1fr);gap:1vw;align-content:center; margin: 0 10vw 0 10vw; padding: 2vh 0;">
				<div style="grid-column: 1 / span 2;">
					<div id="inputid"></div>
				</div>
			</div>
		</div>
	</div>
</div>

<?= view(
	"layouts/bcr-nav",
	[
		"title" => "Recipe",
		"controller" => "Recipes",
		"links" => [
			"Back" =>  ["url" => url_to("Recipes::index"), "auth_check" => true],
			"New" =>  ["url" => url_to("Recipes::new"), "auth_check" => true],
			"Printable version of this page" =>  ["url" => base_url("Recipes/print/$recipe->RecipeID"), "auth_check" => true, "target" => "_blank"],
		]
	]
) ?>

<div class="round-border">


	<div id="recipes-outer" style="display: grid; gap:1rem; grid-template-columns:1fr;">

<!-- 		<div style="display:grid; gap:1rem; grid-template-columns:repeat(4,100px) 480px;">
			<div>
				<a class="button" href="<?= previous_url() ?>">Back</a>
			</div>
			<div>
				<a class="button" href="<?= url_to("Recipes::index") ?>">Recipe List</a>
			</div>
			<div>
				<a class="button" href="<?= url_to("Recipes::new") ?>">New</a>
			</div>
			<div>
				<a class="button" href="<?= site_url("/Recipes/print") . '/' . $recipe->RecipeID ?>" target="_blank" title="Display a printable version of this page">Printable</a>
			</div>
 -->
			<?= $this->include("layouts/bomcalc") ?>

		<!-- </div> -->

		<div style="display: grid; row-gap: 1rem; grid-template-columns:1fr 1fr">
			<div id="recipes-heading" style="background-color: <?= $recipe->HeaderColour ?>;"><?= $recipe->RecipeName ?></div>
			<div id="recipes-heading" style="background-color: <?= $recipe->HeaderColour ?>;"><?= $recipe->RecipeCode ?></div>
		</div>
		<div id="recipes-main">

			<?= $this->include("Recipes/showheader") ?>

			<div id="recipes-main-edit" style="display: grid; gap: 1rem; grid-template-columns:repeat(3,1fr);">
				<a class="button" href="<?= url_to("Recipes::edit", $recipe->RecipeID) ?>">Edit</a>
				<a class="button" href="<?= url_to("Recipes::imageedit", $recipe->RecipeID) ?>">Image Library</a>

				<a class="button" style="background-color: red;" href="#" onclick="deleteRecipe();">Delete</a>
			</div>
		</div>

		<div id="recipes-inputs">
			<?php
			if (session()->has("errors")) : ?>
				<ul style="padding:3px;border-style:solid;border-width:1px;border-radius:5px; background-color:crimson;color:white;">
					<?php
					foreach (session("errors") as $error) : ?>
						<li style="color:white ;"><?= $error ?></li>
					<?php
					endforeach; ?>
				</ul>
			<?php
			endif; ?>
			<?php $infomsg = "";
			if (session()->has("inputmessage")) {
				$infomsg = session("inputmessage");
			}
			if (!session()->has("errors")) {
				if ($recipe->qtyincwaste - $recipe->qtytotal > 0) {
					if ($infomsg <> "") {
						$infomsg = $infomsg . "<br/>";
					}
					$infomsg = $infomsg . $recipe->qtyincwaste - $recipe->qtytotal . "g of coffee to go";
				}
			}
			if ($infomsg <> "") :
			?>
				<p style="padding:3px;border-style:solid;border-width:1px;border-radius:5px; background-color:cornflowerblue;color:white;"><?= $infomsg ?></p>
			<?php
			endif; ?>

			<?= form_open("recipeinputs/" . $recipe->RecipeID) ?>
			<div id="recipes-inputs-add"
				style="display: grid; gap: 1rem; grid-template-columns:70px 250px 150px 100px 180px;">

				<label for="InputID" title="Alt+I">
					<u><b>I</b></u>nput</label>
				<select class="select2" name="InputID" id="InputID" accesskey="I" title="Alt+I">
					<?php $currentinputype = 0; ?>
					<?php
					foreach ($inputs as $input) : ?>
						<?php
						if ($input->InputTypeID !== $currentinputype) : ?>
							<?php
							if ($currentinputype > 0) : ?>
								</optgroup>
							<?php
							endif; ?>
							<?php $currentinputype = $input->InputTypeID; ?>
							<optgroup label="<?= $input->InputType ?>">
								<option value="<?= $input->InputID ?>">
									<?= $input->InputName ?>
								</option>
							<?php else : ?>
								<option value="<?= $input->InputID ?>">
									<?= $input->InputName ?>
								</option>
							<?php
						endif; ?>
						<?php
					endforeach; ?>
							</optgroup>
				</select>

				<label for="Qty" title="Alt+Q">
					<u><b>Q</b></u>ty (grams or each)</label>
				<input type="number" name="Qty" id="Qty" value="1" accesskey="Q" title="Alt+Q">
				<button class="button" type="submit" accesskey="A" title="Alt+A">
					<u><b>A</b></u>dd Input</button>
			</div>
			</form>

			<?php $recipe->showRemove = true; ?>
			<?= $this->include("Recipes/showinputs") ?>

			<div>
			</div>

		</div>
		<?= $this->endSection() ?>

		<?= $this->section("javascript") ?>

		<script src="<?= base_url('js/lightbox2/dist/js/lightbox.js') ?>"></script>

		<script type='text/javascript'>
			function openNav(t) {
				var id = t.id;
				let csrfField = document.getElementById('csrfcode');
				let htmxpath = "<?= base_url("InputCosts/peek") ?>"
				let csrfname = csrfField.name;
				let csrfval = csrfField.value;
				//alert(csrfname + '=' + csrfval);
				let vals = {};
				vals['inputid'] = id;
				vals[csrfname] = csrfval;
				htmx.ajax('POST',
					htmxpath, {
						target: "#inputid",
						swap: 'none',
						handler: (_, response) => {
							res = JSON.parse(response.xhr.response);
							$('#csrfcode').val(res.token);
							$('#inputid').html(res.view);
						},
						values: vals
					}
				);
				document.getElementById("myNav").style.width = "100%";
			}

			function closeNav() {
				document.getElementById("myNav").style.width = "0%";

			}

			function deleteRecipe() {
				DayPilot.Modal.confirm("Are you sure you want to DELETE this recipe ?", {
					theme: "modal_rounded"
				}).then(function(args) {
					let htmxpath = "<?= base_url("Recipes/htmxDelete") ?>"
					let csrfField = document.getElementById('csrfcode');
					let csrfname = csrfField.name;
					let csrfval = csrfField.value;

					let vals = {};
					vals['recipeid'] = "<?= $recipe->RecipeID ?>";
					vals[csrfname] = csrfval;

					htmx.ajax(
						'POST',
						htmxpath, {
							target: "body",
							swap: 'none',
							handler: (_, response) => {
								res = JSON.parse(response.xhr.response);
								$('#csrfcode').val(res.token);
								//$('body').html(res.view);
								window.location = "<?= base_url('recipes') ?>"
							},
							values: vals
						}
					);
				});
			}
		</script>


		<?= $this->endSection() ?>