<?= $this->extend("layouts/print") ?>

<?= $this->section("title") ?>Coffee Price List Internal Use only<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"></script>
<link rel="stylesheet" href="<?= base_url('/js/select2/dist/css/select2.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/select2/dist/js/select2.min.js') ?>"></script>
<link rel="stylesheet" href="<?= base_url('/css/recipes.css') . '?' . rand() ?>" />

<style>
    .sectdiv {
        padding-top: 3px;
        padding-bottom: 3px;
    }

    .headdiv {
        padding-left: 3px;
        padding-right: 3px;
        border-style: solid;
        border-width: 1px;
        border-color: lightgrey;
    }

    .celldiv {
        width: auto;
        padding-left: 3px;
        padding-right: 3px;
        border-style: solid;
        border-width: 1px;
        border-color: lightgrey;
    }

    .spacediv {
        /* max-width:5px; */
    }
</style>

<?= $this->endSection() ?>


<?= $this->section("content") ?>

<a href="<?= site_url('/') ?>"> <img style="max-width: 7vw;" src="<?= base_url('/images/RoastPRO-02.jpg') ?>" alt=""></a>

<?php if ($displaytype == '0'): ?>
    <!-- Internal Price List -->
    <div style="display: grid; gap:0px; grid-template-columns:repeat(11,1fr) 15px repeat(3,1fr) 15px repeat(3,1fr) 15px repeat(3,1fr);">
        <!-- <div style="grid-column: 1 / span 23;"><h2>Coffee Price List Internal Use only</h2><div> -->
    <?php else: ?>
        <!-- Customer List -->
        <div style="display: grid; gap:0px; grid-template-columns:repeat(8,1fr);">
            <!-- <div style="grid-column: 1 / span 8;"><h2>Customer Price List</h2><div> -->
        <?php endif; ?>

        <?php if ($displaytype == '0'): ?>
            <!-- Internal Price List -->
            <div style="grid-column: 1 / SPAN 23; color:white;background-color:white;">
                <h2>Coffee Price List Internal Use only</h2>
            </div>
        <?php else: ?>
            <div style="grid-column: 1 / SPAN 8; color:white;background-color:white;">
                <h2>Customer Price List</h2>
            </div>
        <?php endif; ?>

        <?php $categoryid = 0; ?>
        <?php foreach ($pricelist as $price): ?>
            <?php if ($price->CategoryID <> $categoryid): ?>

                <?php if ($displaytype == '0'): ?>
                    <!-- Internal Price List -->
                    <div style="grid-column: 1 / SPAN 23; color:white;background-color:white;min-height:30px;"></div>
                <?php else: ?>
                    <div style="grid-column: 1 / SPAN 8; color:white;background-color:white;min-height:30px;"></div>
                <?php endif; ?>

                <div class="sectdiv" style="grid-column: 1 / SPAN <?= $displaytype == '0' ? 11 : 8 ?>; color:white;background-color:<?= $price->HeaderColour ?>;"><?= $price->Category ?></div>

                <?php if ($displaytype == '0'): ?>
                    <div class="spacediv" style="grid-column: 12;"></div>
                    <div class="sectdiv" style="text-align:center; grid-column: 13 / SPAN 3; color:white;background-color:<?= $price->HeaderColour ?>;">Wholesale Price</div>
                    <div class="spacediv" style="grid-column: 16;"></div>
                    <div class="sectdiv" style="text-align:center; grid-column: 17 / SPAN 3; color:white;background-color:<?= $price->HeaderColour ?>;">Discounts</div>
                    <div class="spacediv" style="grid-column: 20;"></div>
                    <div class="sectdiv" style="text-align:center; grid-column: 21 / SPAN 3; color:white;background-color:<?= $price->HeaderColour ?>;">BCR GPM</div>
                <?php endif; ?>



                <div class="headdiv" style="background-color: <?= $price->BodyColour ?>;">Product Code</div>
                <div class="headdiv" style="background-color: <?= $price->BodyColour ?>;">Product</div>
                <div class="headdiv" style="background-color: <?= $price->BodyColour ?>;">Description</div>
                <div class="headdiv" style="background-color: <?= $price->BodyColour ?>;">Certification</div>
                <div class="headdiv" style="background-color: <?= $price->BodyColour ?>;">Roast Level</div>
                <div class="headdiv" style="background-color: <?= $price->BodyColour ?>;">Unit Size</div>
                <div class="headdiv" style="background-color: <?= $price->BodyColour ?>;">Outer</div>
                <?php if ($displaytype == '0'): ?>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">Cost<br />(unit)</div>
                <?php endif; ?>

                <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">RRP<br />(unit)</div>
                <?php if ($displaytype == '0'): ?>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">GP</div>
                <?php endif; ?>

                <?php if ($displaytype == '0'): ?>
                    <div class="" style="background-color: <?= $price->BodyColour ?>;">GPM</div>

                    <div class="spacediv"></div>

                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">1000<br />units PA</div>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">5000<br />units PA</div>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">10000+</div>

                    <div class="spacediv"></div>

                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;"><a href="<?= site_url('/Categories') . '/' . $price->CategoryID . '/edit/' . ($displaytype == '0' ? 1 : 2) ?>"><?= $price->Discount1 ?>%</a></div>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;"><a href="<?= site_url('/Categories') . '/' . $price->CategoryID . '/edit/' . ($displaytype == '0' ? 1 : 2) ?>"><?= $price->Discount2 ?>%</a></div>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;"><a href="<?= site_url('/Categories') . '/' . $price->CategoryID . '/edit/' . ($displaytype == '0' ? 1 : 2) ?>"><?= $price->Discount3 ?>%</a></div>

                    <div class="spacediv"></div>

                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">1000<br />units PA</div>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">5000<br />units PA</div>
                    <div class="headdiv" style="text-align:center;background-color: <?= $price->BodyColour ?>;">10000+</div>
                <?php endif; ?>

                <?php $categoryid = $price->CategoryID; ?>
            <?php endif; ?>
            <div class="celldiv"><?= $price->RecipeCode ?></div>
            <div style="min-width:15rem;" class="celldiv"><a href="<?= site_url('/recipes') . '/' . $price->RecipeID ?>"><?= $price->RecipeName ?></a></div>
            <div style="min-width:20rem;" class="celldiv"><?= $price->Description ?></div>
            <div class="celldiv"><?= $price->certs ?></div>
            <div class="celldiv"><?= $price->RoastLevel ?></div>
            <div class="celldiv"><?= $price->UnitSize ?></div>
            <div class="celldiv"><?= $price->OuterSize ?></div>
            <?php if ($displaytype == '0'): ?>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->InputCost,2) ?></div>
            <?php endif; ?>

            <div style="text-align: right;" class="celldiv">£<?= number_format($price->RRP,2) ?></div>
            <?php if ($displaytype == '0'): ?>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->GP,2) ?></div>
                <div style="text-align: right;" class="celldiv"><?= number_format($price->GPM,2) ?>%</div>
                <div class="spacediv"></div>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->wp1000,2) ?></div>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->wp5000,2) ?></div>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->wp10000,2) ?></div>
                <div class="spacediv"></div>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->discount10,2) ?></div>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->discount15,2) ?></div>
                <div style="text-align: right;" class="celldiv">£<?= number_format($price->discount30,2) ?></div>
                <div class="spacediv"></div>
                <div style="text-align: right;" class="celldiv"><?= number_format($price->GPM1000,2) ?>%</div>
                <div style="text-align: right;" class="celldiv"><?= number_format($price->GPM5000,2) ?>%</div>
                <div style="text-align: right;" class="celldiv"><?= number_format($price->GPM10000,2) ?>%</div>
            <?php endif; ?>

        <?php endforeach; ?>
        </div>

        <?= $this->endSection() ?>