<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Recipes<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<link rel="stylesheet" href="<?= base_url('/js/tabulator-master/dist/css/tabulator_simple.css') ?>" />

<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/luxon.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/tabulator-master/dist/js/tabulator.min.js') ?>"> </script>
<style>
	.tabulator-row.tabulator-selectable:hover {
		background-color: #bbb !important;
	}
</style>
<?= $this->endSection() ?>

<?= $this->section("content") ?>


<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Recipes",
        "controller" => "Recipes",
        "links" => [
            "New" =>  ["url" => url_to("Recipes::new"), "auth_check" => true]
        ]
    ]
) ?>

<?= view("layouts/tabulatorgrid") ?>

<script type='text/javascript'>
	//$rowHoverBackground = #ffffff;

	new Tabulator('#wrapper', {
		rowFormatter: function(row) {
			//row - row component

			var data = row.getData();
			var style = row.getElement().style;
			//if (data.AnnualKg > 0) {
			row.getElement().style.backgroundColor = data.BodyColour; //  "#76EE00";
			//row.getElement().style.Selection = data.HeaderColour; //  "#76EE00";
			row.getElement().style.color = "#000000"; //  "#76EE00";
			//}
		},
		data: [
			<?php foreach ($recipes as $recipe): ?>
				<?= "{" ?>
				<?= "RecipeID:$recipe->RecipeID," ?>
				<?= "RecipeName:'" . addslashes($recipe->RecipeName) . "'," ?>
				<?= "RecipeCode:'" . addslashes($recipe->RecipeCode) . "'," ?>
				<?= "Category:'" . addslashes($recipe->Category) . "'," ?>
				<?= "RoastLevel:'" . addslashes($recipe->RoastLevel) . "'," ?>
				<?= "PackQty:$recipe->PackQty," ?>
				<?= "OuterSize:$recipe->OuterSize," ?>
				<?= "AnnualKg:$recipe->AnnualKg," ?>
				<?= "SellPriceKg:$recipe->SellPriceKg," ?>
				<?= "ValidFromDate:'$recipe->ValidFromDate'," ?>
				<?= "NextSellPriceKg:$recipe->NextSellPriceKg," ?>
				<?= "NextValidFromDate:'$recipe->NextValidFromDate'," ?>
				<?= "lastupdated:'$recipe->lastupdated'," ?>
				<?= "updatedby:'$recipe->username'," ?>
				<?= "FooterColour:'$recipe->FooterColour'," ?>
				<?= "BodyColour:'$recipe->BodyColour'," ?>
				<?= "HeaderColour:'$recipe->HeaderColour'," ?>
				<?= "}," ?>
				<?= chr(13) . chr(10) ?>
			<?php endforeach; ?>
		],
		layout: "fitDataStretch",
		pagination: false,
		//height:"100%",
		//paginationSize: 25,
		tooltips: true,
		//maxHeight:"100vh",
		//editTriggerEvent:"click",
		columns: [{
			title: "RecipeID",
			field: "RecipeID",
			sorter: "number",
			width: 150,
			visible: false,
		}, {
			title: "Recipe Name",
			field: "RecipeName",
			sorter: "string",
			hozAlign: "left",
			width: 200,
			headerFilter: "input",
		}, {
			title: "Product Code",
			field: "RecipeCode",
			sorter: "string",
			hozAlign: "left",
			width: 170,
			headerFilter: "input",
		}, {
			title: "Category",
			field: "Category",
			sorter: "string",
			hozAlign: "left",
			width: 200,
			headerFilter: "list",
			headerFilterParams: {
				valuesLookup: true,
				clearable: true
			},
		}, {
			title: "Roast Level",
			field: "RoastLevel",
			sorter: "string",
			hozAlign: "left",
			width: 120,
			headerFilter: "list",
			headerFilterParams: {
				valuesLookup: true,
				clearable: true
			},
		}, {
			title: "Finished<br/>Weight(g) ",
			field: "PackQty",
			sorter: "number",
			hozAlign: "right",
			width: 120,
		}, {
			title: "Packs per<br/>Outer",
			field: "OuterSize",
			sorter: "number",
			hozAlign: "right",
			width: 120,
		}, {
			title: "Annual Kg",
			field: "AnnualKg",
			sorter: "number",
			hozAlign: "right",
			width: 120,
			// editor:"number",
			// editorParams:{
			//     min:0,
			//     //max:100,
			//     step:10,
			//     // elementAttributes:{
			//     //     maxlength:"10", //set the maximum character length of the input element to 10 characters
			//     // },
			//     //mask:"999",
			//     selectContents:true,
			//     verticalNavigation:"table", //up and down arrow keys navigate away from cell without changing value
			// }
		}, {
			title: "Sell Price Kg",
			field: "SellPriceKg",
			sorter: "number",
			hozAlign: "right",
			width: 120,
			formatter:"money", formatterParams:{
			    decimal:".",
			    thousand:"",
			    symbol:"",
			    symbolAfter:"",
			    negativeSign:true,
			    precision:2,
			}
		},{
            title: "Price Valid From",
            field: "ValidFromDate",
            hozAlign: "left",
            responsive: 4,
            formatter: "datetime",
            formatterParams: {
                inputFormat: "yyyy-LL-dd",
                outputFormat: "dd/MM/yyyy",
                invalidPlaceholder: "(invalid date)",
                timezone: "system",
            },
            sorter: "datetime",
            sorterParams: {
                format: "yyyy-MM-dd HH:mm:ss",
                alignEmptyValues: "top",
            }

        },{
			title: "Next Sell Price Kg",
			field: "NextSellPriceKg",
			sorter: "number",
			hozAlign: "right",
			width: 120,
			formatter:"money", formatterParams:{
			    decimal:".",
			    thousand:"",
			    symbol:"",
			    symbolAfter:"",
			    negativeSign:true,
			    precision:2,
			}
		}, {
			title: "Next Valid From",
			field: "NextValidFromDate",
			hozAlign: "left",
			responsive: 4,
            formatter: "datetime",
            formatterParams: {
                inputFormat: "yyyy-LL-dd",
                outputFormat: "dd/MM/yyyy",
                invalidPlaceholder: "(invalid date)",
                timezone: "system",
            },
            sorter: "datetime",
            sorterParams: {
                format: "yyyy-MM-dd HH:mm:ss",
                alignEmptyValues: "top",
            }
		}, {
			title: "Record Updated",
			field: "lastupdated",
			sorter: "datetime",
			hozAlign: "left",
			width: 150,
            formatter: "datetime",
            formatterParams: {
                inputFormat: "yyyy-LL-dd TT",
                outputFormat: "dd/MM/yyyy hh:mm:ss",
                invalidPlaceholder: "(invalid date)",
                timezone: "system",
            },
            sorter: "datetime",
            sorterParams: {
                format: "yyyy-MM-dd HH:mm:ss",
                alignEmptyValues: "top",
            }
		}, {
			title: "Updated By",
			field: "updatedby",
			sorter: "string",
			hozAlign: "left",
			width: 200,
			headerFilter: "list",
			headerFilterParams: {
				valuesLookup: true,
				clearable: true
			},
		}, {
			title: "FooterColour",
			field: "FooterColour",
			sorter: "number",
			width: 150,
			visible: false,
		}, {
			title: "BodyColour",
			field: "BodyColour",
			sorter: "number",
			width: 150,
			visible: false,
		}, {
			title: "HeaderColour",
			field: "HeaderColour",
			sorter: "number",
			width: 150,
			visible: false,
		}, ],
	}).on('cellClick', function(e, cell) {
		//alert(cell.getColumn().getField());
		//            if(cell.getColumn().getField() != 'AnnualKg'){
		//alert(cell.getRow().getCell('RecipeID').getValue());
		window.location = '<?= base_url("recipes") . "/" ?>' + cell.getRow().getCell('RecipeID').getValue();
		//            }
		//window.location = '<?= base_url("recipes") . "/" ?>' + row.getCell('RecipeID').getValue();
	});
</script>

<?= $this->endSection() ?>

<?= $this->section("javascript") ?>
<?= $this->endSection() ?>