<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>Edit Images<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"> </script>
<link rel="stylesheet" href="<?= base_url('/js/select2/dist/css/select2.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/select2/dist/js/select2.min.js') ?>"> </script>
<link rel="stylesheet" href="<?= base_url('/css/imagecarousel.css') . '?' . rand() ?>" />
<link href="<?= base_url('js/lightbox2/dist/css/lightbox.css') ?>" rel="stylesheet" />

<script type='text/javascript' src="<?= base_url('js/htmx/htmx.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js'); ?>"></script>
<link rel="stylesheet" href="<?= base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">

<script type='text/javascript'>
    $(document).ready(function() {
        $('.select2').select2();
    });
    $(function() {
        var focusedElement;
        $(document).on('focus', 'input', function() {
            if (focusedElement == this)
                return; //already focused, return so user can now place cursor at specific point in input.
            focusedElement = this;
            setTimeout(function() {
                focusedElement.select();
            }, 100); //select all text in any field on focus for easy re-entry. Delay sightly to allow focus to "stick" before selecting.
        });
    });
</script>

<?= $this->endSection() ?>

<?= $this->section("content") ?>

<?= $this->include("Recipes/backbtn") ?>

<h1>Image Library for <?= $recipe->RecipeName ?></h1>


<?php if (session()->has("uploaderrors")): ?>
    <ul>
        <?php foreach (session()->get("uploaderrors") as $error): ?>
            <li style="color: red;"><?= $error ?></li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>
<div style="display:grid; gap: 5px; grid-template-columns: repeat(6, 1fr);align-content: center;">
    <?php $imagecount = 0; ?>
    <?php foreach ($images as $key => $image): ?>
        <?php if($recipe->ImageID == $image->ImageID): ?>
            <div style="border-style: solid; border-width: 5px; border-color: #e04d2b; border-radius: 5px;padding:10px;">
                <div class="button font-normal-300-small" style="text-align: center; color:white; background-color: white;">Default Image
                </div>
        <?php else: ?>
            <div style="border-style: solid; border-width: 3px; border-color: #213242; border-radius: 5px;padding:10px;">
                <div class="font-normal-300-small" style="text-align: center;">
                    <a id="<?= $image->ImageID ?>" class="button font-normal-300-small" style="color:white;" onclick="set_default_click(this.id);">Set as Default Image</a>
                </div>
        <?php endif; ?>
                <a href="<?= $image->ImageName ?>" data-lightbox="pack-image" data-title=".">
                    <img class="example-image" src="<?= $image->ImageName ?>" alt="<?= $image->ImageID ?>" style="max-width:10vw; max-height:10vw;">
                </a>
                <div style="text-align: center;">
                    <a id="<?= $image->ImageID ?>" class="button" onclick="delete_image_click(this.id);">Delete</a>
                </div>
            </div>
        <?php $imagecount++; ?>
    <?php endforeach; ?>
</div>
<div style="margin-top: 20px;">

    <?= form_open_multipart("recipes/$recipe->RecipeID/uploadimage/$imagecount") ?>
    <div style="display:grid;">
        <div>
            <h1>Upload New Image</h1>
        </div>
        <div>
            <input class="bvr-blue-text" type="file" name="userfile" size="20">
        </div>
        <div>
            <input class="button" type="submit" value="upload">
        </div>
    </div>
    </form>
</div>
<?= $this->endSection() ?>

<?= $this->section("javascript") ?>

<script src="<?= base_url('js/lightbox2/dist/js/lightbox.js') ?>"></script>

<script type='text/javascript'>
    function delete_image_click(id) {
        DayPilot.Modal.confirm("Do you want to DELETE this Image?", {
            theme: "modal_rounded"
        }).then(function(args) {
            if (args.result) {
                window.location = '<?=base_url("Recipes")?>'+'/'+id+'/imagedelete';
            }
        });
    }

    function set_default_click(id) {
        window.location = '<?=base_url("Recipes")?>'+'/'+id+'/imagesetdefault';
    }
</script>
<?= $this->endSection() ?>