<div class="round-border">
    <div id="myNav" class="overlay">
        <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
        <div class="overlay-content">
            <div style="border-style:solid; border-width:2px; border-radius:5px; border-color:#818181; font-size: 36px !important;color: #818181 !important; margin: 0 10vw;">
                <div style="display:grid; grid-template-columns:repeat(2,1fr);gap:1vw;align-content:center; margin: 0 10vw 0 10vw; padding: 2vh 0;">
                    <div style="grid-column: 1 / span 2;">
                        <div id="inputid"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <main style="padding:1em; display:grid; gap:1rem; grid-template-columns:repeat(3,1fr);">
        <input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

        <?php if ($recipe->showtemplates == true): ?>
            <div style="grid-column-start: 1;  grid-column-end: span 2; align-self:end;">
                <label for="TemplateID">Template to use when creating new recipe</label>
                <select name="TemplateID" id="TemplateID" style="width:-webkit-fill-available;">
                    <?php foreach ($templates as $template): ?>
                        <option value="<?= $template->TemplateID ?>">
                            <?= $template->TemplateName ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div style="grid-column:3; align-self:end;">
                <a href="<?= url_to("Templates::new") ?>" class="button">Create New Template</a>
            </div>
        <?php endif; ?>

        <div>
            <label for="RecipeName">Recipe Name</label>
            <input type="text" id="RecipeName" name="RecipeName" size="80" autocomplete="off"
                value="<?= old("RecipeName", esc($recipe->RecipeName)) ?>" spellcheck="true" autofocus>
        </div>
        <div>
            <label for="Packqty">Finished Weight(g)</label>
            <input type="number" id="PackQty" name="PackQty" step="0.01"
                value="<?= old("PackQty", esc($recipe->PackQty)) ?>">
        </div>
        <div>
            <label for="RecipeCode">Product Code</label>
            <input type="text" id="RecipeCode" name="RecipeCode" autocomplete="off"
                value="<?= old("RecipeCode", esc($recipe->RecipeCode)) ?>" spellcheck="true">
        </div>

        <div>
            <label for="CategoryID">Category</label>
            <select name="CategoryID" id="CategoryID" class="InputRequired" width="400px" required>
                <?php foreach ($categories as $category): ?>
                    <option value="<?= $category->CategoryID ?>"
                        <?= $category->CategoryID == $recipe->CategoryID ? 'selected' : '';  ?>>
                        <?= $category->Category ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="RoastLevelID">Roast Level</label>
            <select name="RoastLevelID" id="RoastLevelID" width="400px">
                <?php foreach ($roastlevels as $roastlevel): ?>
                    <option value="<?= $roastlevel->RoastLevelID ?>"
                        <?= $roastlevel->RoastLevelID == $recipe->RoastLevelID ? 'selected' : '';  ?>>
                        <?= $roastlevel->RoastLevel ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="RoastColourNo">Agtron Number</label>
            <input type="number" id="RoastColourNo" name="RoastColourNo" step="1"
                value="<?= old("RoastColourNo", esc($recipe->RoastColourNo)) ?>">
        </div>

        <div>
            <label for="storage_location">Warehouse Storage Location</label>
            <input type="text" name="storage_location" id="storage_location" value="<?= old("storage_location", esc($recipe->storage_location)) ?>">
        </div>
        <div>
            <label for="WastePercent">Production Waste of Coffee(%)</label>
            <input type="number" id="WastePercent" name="WastePercent" step="1"
                value="<?= old("WastePercent", esc($recipe->WastePercent)) ?>">
        </div>
        <div>
            <label for="AnnualKg">Annual Kg</label>
            <input type="number" id="AnnualKg" name="AnnualKg" step="0.01" autocomplete="off"
                value="<?= old("AnnualKg", esc($recipe->AnnualKg)) ?>">
        </div>
        <div>
            <label for="OuterSize">Number of Units in an Outer</label>
            <input type="number" id="OuterSize" name="OuterSize" step="1"
                value="<?= old("OuterSize", esc($recipe->OuterSize)) ?>">
        </div>


        <?php if (!(null == $recipe->RecipeID || empty($recipe->RecipeID))): ?>
            <div id="pricing" style="grid-column: 1 / SPAN 3;  display: grid; grid-template-columns: repeat(4, 10em); border-style: solid; border-radius: 5px; border-color:#213242; width: 42em; padding: 1em;">
                <div class="font-normal-800" style="grid-column: 1 / SPAN 4; grid-row: 1; text-align: center; margin: 1em; ">
                    Pricing <br />
                    <a href="#" class="font-normal-300-small" style="color:#e04d2b;/* color:#213242*/" onclick="openNav();">Where did I get these dates from?</a>
                </div>

                <div class="font-normal-600 recipe-price" style="grid-column: 1; grid-row: 2;">
                    <div>Current Sell Price</div>
                </div>
                <div class="font-normal-600 recipe-price" style="grid-column: 1; grid-row: 3;">
                    <div>Valid From</div>
                </div>
                <div style="grid-column: 2; grid-row: 3;">
                    <input type="hidden" name="ValidFromDate" id="ValidFromDate" value="<?= date_format(date_create($recipe->ValidFromDate), "Y/m/d") ?>">
                    <div id="ValidFrom"><?= date_format(date_create($recipe->ValidFromDate), "d/m/Y") ?></div>
                </div>
                <div class="font-normal-600 recipe-price" style="grid-column: 1; grid-row: 4;">
                    <div>Total Costs</div>
                </div>
                <div style="grid-column: 2; grid-row: 4;">
                    <div id="TotalCost"><?= number_format($recipe->TotalCost,2) ?></div>
                </div>

                <div class="font-normal-600 recipe-price" style="grid-column: 1; grid-row: 5;">
                    <label for="SellPriceKg">Sell Price per Unit</label>
                </div>
                <div style="grid-column: 2; grid-row: 5;">
                    <input type="number" id="SellPriceKg" name="SellPriceKg" step="0.01" style="width: 8em;"
                        value="<?= number_format(old("SellPriceKg", esc($recipe->SellPriceKg)),2,'.','') ?>" onblur="SellPriceChange();">
                    <div class="font-normal-300-small" id="SellPriceActual"></div>
                </div>
                <div class="font-normal-600 recipe-price" style="grid-column: 1; grid-row: 6;">
                    <label for="SellPriceGP">GP(%)</label>
                </div>
                <div style="grid-column: 2; grid-row: 6;">
                    <input type="number" id="SellPriceGP" name="SellPriceGP" step="0.001" style="width: 8em;"
                        value="<?= number_format(old("SellPriceGP", esc($recipe->SellPriceGP)),3,'.','') ?>" onblur="GPChange();">
                </div>


                <div class="font-normal-600 recipe-price" style="grid-column: 3; grid-row: 2;">
                    <div>Next Sell Price</div>
                </div>
                <div class="font-normal-600 recipe-price" style="grid-column: 3; grid-row: 3;">
                    <div>Valid From</div>
                </div>
                <div style="grid-column: 4; grid-row: 3;">
                    <input type="hidden" name="NextValidFromDate" id="NextValidFromDate" value="<?= date_format(date_create($recipe->NextValidFromDate), "Y/m/d") ?>">
                    <div id="NextValidFrom"><?= date_format(date_create($recipe->NextValidFromDate), "d/m/Y") ?></div>
                </div>
                <div class="font-normal-600 recipe-price" style="grid-column: 3; grid-row: 4;">
                    <div>Total Costs</div>
                </div>
                <div style="grid-column: 4; grid-row: 4;">
                    <div id="NextTotalCost"><?= number_format($recipe->NextTotalCost,2) ?></div>
                </div>

                <div class="font-normal-600 recipe-price" style="grid-column: 3; grid-row: 5;">
                    <label for="NextSellPriceKg">Sell Price per Unit</label>
                </div>
                <div style="grid-column: 4; grid-row: 5;">
                    <input type="number" id="NextSellPriceKg" name="NextSellPriceKg" step="0.01" style="width: 8em;"
                        value="<?= number_format(old("NextSellPriceKg", esc($recipe->NextSellPriceKg)),2,'.','') ?>" onblur="NextSellPriceChange();">
                    <div class="font-normal-300-small" id="NextSellPriceActual"></div>
                </div>
                <div class="font-normal-600 recipe-price" style="grid-column: 3; grid-row: 6;">
                    <label for="NextSellPriceGP">GP(%)</label>
                </div>
                <div style="grid-column: 4; grid-row: 6;">
                    <input type="number" id="NextSellPriceGP" name="NextSellPriceGP" step="0.001" style="width: 8em;"
                        value="<?= number_format(old("NextSellPriceGP", esc($recipe->NextSellPriceGP)),3,'.','') ?>" onblur="NextGPChange();">
                </div>
                <?php if($donotdropprices && $recipe->NextSellPriceKg < $recipe->SellPriceKg): ?>
                <div class="font-normal-300-small" style="color:#DC143C; grid-column: 1 / SPAN 4; grid-row: 7;">
                    <div>Because Next Sell Price is less than current Sell Price the Next Sell Price will remain at <?= number_format($recipe->SellPriceKg,2,'.','') ?> in the recipes list</div>
                </div>
                <?php endif; ?>

            </div>
        <?php endif; ?>

        <div style="grid-column-start: 1;  grid-column-end: span 3;">
            <label for="Description">Description (for price list)</label>
            <textarea name="Description" id="Description" rows="5"><?= old("Description", esc($recipe->Description)) ?></textarea>
        </div>

        <div style="grid-column-start: 1;  grid-column-end: span 3;">
            <label for="Notes">Notes</label>
            <textarea name="Notes" id="Notes" rows="10"><?= old("Notes", esc($recipe->Notes)) ?></textarea>
        </div>


        <div style="grid-column-start: 1; grid-column-end: span 3; text-align: center;">
            <button class="button" type="submit">Save</button>
            <a class="button" href="<?= site_url('/recipes') . '/' . $recipe->RecipeID ?>" default>Cancel</a>
        </div>
    </main>
</div>

<script type='text/javascript'>
    function openNav() {
        let csrfField = document.getElementById('csrfcode');
        let htmxpath = "<?= base_url("InputCosts/htmxinputvalidfromdates") ?>"
        let csrfname = csrfField.name;
        let csrfval = csrfField.value;

        //alert(csrfname + '=' + csrfval);
        let vals = {};
        vals['recipeid'] = '<?= $recipe->RecipeID ?>';
        vals['validfromdate'] = '<?= $recipe->ValidFromDate ?>';
        vals['nextvalidfromdate'] = '<?= $recipe->NextValidFromDate ?>';
        vals[csrfname] = csrfval;
        htmx.ajax('POST',
            htmxpath, {
                target: "#inputid",
                swap: 'none',
                handler: (_, response) => {
                    res = JSON.parse(response.xhr.response);
                    $('#csrfcode').val(res.token);
                    $('#inputid').html(res.view);
                },
                values: vals
            }
        );
        document.getElementById("myNav").style.width = "100%";
    }

    function closeNav() {
        document.getElementById("myNav").style.width = "0%";

    }
</script>