<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>Edit Recipe<?= $this->endSection() ?>


<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"></script>
<link rel="stylesheet" href="<?= base_url('css/overlay.css') ?>" />
<script type='text/javascript' src="<?=base_url('/js/htmx/htmx.min.js');?>"></script>

<?= $this->endSection() ?>


<?= $this->section("content") ?>


<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Edit Recipe",
        "controller" => "Recipes",
        "links" => [
            "Back" =>  ["url" => base_url("recipes/$recipe->RecipeID"), "auth_check" => false],
            "Recipes List" =>  ["url" => base_url("recipes"), "auth_check" => false]
        ]
    ]
) ?>

<?= form_open("recipes/" . $recipe->RecipeID) ?>

<input type="hidden" name="_method" value="PATCH">

<?php $recipe->showtemplates = false; ?>
<?= $this->include("Recipes/form") ?>

</form>

<?= $this->endSection() ?>

<?= $this->section("javascript") ?>
<script type='text/javascript'>

    function SellPriceChange(){
        var cost = parseFloat($('#TotalCost').html()) || 0.0;
        var sell = parseFloat($('#SellPriceKg').val()) || 0.0;
        var gp = calcGP(cost, sell);
        $('#SellPriceGP').val(gp);

        // sell = calcSellPrice(cost, gp);
        // $('#SellPriceKg').val(sell);
        // var sellprecise = calcSellPricePrecise(cost, gp);
        // $('#SellPriceActual').html(sellprecise);
    }


    function GPChange(){
        var cost = parseFloat($('#TotalCost').html()) || 0.0;
        var gp = parseFloat($('#SellPriceGP').val()) || 0.0;

        var sell = calcSellPrice(cost, gp);
        $('#SellPriceKg').val(sell);

        var sellprecise = calcSellPricePrecise(cost, gp);
        $('#SellPriceActual').html(sellprecise);

        // gp = calcGP(cost, sell);
        // $('#SellPriceGP').val(gp);
    }


    function NextGPChange(){
        var cost = parseFloat($('#NextTotalCost').html()) || 0.0;
        var gp = parseFloat($('#NextSellPriceGP').val()) || 0.0;

        var sell = calcSellPrice(cost, gp);
        $('#NextSellPriceKg').val(sell);

        var sellprecise = calcSellPricePrecise(cost, gp);
        $('#NextSellPriceActual').html(sellprecise);

        // gp = calcGP(cost, sell);
        // $('#NextSellPriceGP').val(gp);

    }

    function NextSellPriceChange(){
        var cost = parseFloat($('#NextTotalCost').html()) || 0.0;
        var sell = parseFloat($('#NextSellPriceKg').val()) || 0.0;
        var gp = calcGP(cost, sell);
        $('#NextSellPriceGP').val(gp);

        // sell = calcSellPrice(cost, gp);
        // $('#NextSellPriceKg').val(sell);
        // var sellprecise = calcSellPricePrecise(cost, gp);
        // $('#NextSellPriceActual').html(sellprecise);
    }


    function calcSellPrice(cost, gp)
    {
        // gp = ((s - c) / s)  * 100
        // s * gp / 100 = s - c
        // (s * gp / 100) + c = s
        // c = s - ( s * gp /100)
        // c = s * (1 - (gp/100))
        // s = c / (1 - (gp / 100))
        // Round to nearest 50p
        var sell=0.0;
        if(gp != 0){
            sell = (cost / (1 - (gp /100) ));
            console.log('new sell price='+sell);
            sell = roundStep(sell + 0.499,0.5);
            console.log('new sell price rounded='+sell);
            //sell = roundStep(( (cost / (1 - (gp /100) )) + 0.5) , 0.5).toFixed(2);
            //$('#NextSellPriceActual').html('Precise:'+(Math.round(( (cost / (1 - (gp /100) )) + Number.EPSILON) * 100) / 100).toFixed(2));
        }
        return sell;
    }

    function calcSellPricePrecise(cost, gp)
    {
        // gp = ((s - c) / s)  * 100
        // s * gp / 100 = s - c
        // (s * gp / 100) + c = s
        // c = s - ( s * gp /100)
        // c = s * (1 - (gp/100))
        // s = c / (1 - (gp / 100))
        // Round to nearest 50p
        var sell=0.0;
        if(gp != 0){
            sell = (cost / (1 - (gp /100) ));
            console.log(sell);
            sell = 'Precise:'+ sell.toFixed(2) + ' at ' + gp + '%';
        }
        return sell;
    }

    function calcGP(cost, sell)
    {
        // gp = ((s - c) / s)  * 100
        var gp = 0.0;
        if(sell != 0){
            gp = ((sell - cost) / sell) * 100;
            console.log('gp=' + gp);
            gp = gp.toFixed(3);
            console.log('gp fixed=' + gp);
            //gp = (Math.round( (  (  (  (sell - cost) / sell) + Number.EPSILON) * 100000))/100).toFixed(3);
        }
        return gp;
    }

    function roundStep(value, step) {
        step || (step = 1.0);
        var inv = 1.0 / step;
        return Math.floor(value * inv) / inv;
    }

    // $().ready(() => {
    //     // var sell = parseFloat($('#SellPriceKg').val()) || 0.0;
    //     var gp =  parseFloat($('#SellPriceGP').val()) || 0.0;
    //     // if(sell == 0){
    //         if(gp == 0){
    //             $('#SellPriceGP').val("<?= $defaultgp ?>");
    //         }
    //         GPChange();
    //     // }else{
    //         // SellPriceChange();
    //     // }
    //     // sell = parseFloat($('#NextSellPriceKg').val()) || 0.0;
    //     gp =  parseFloat($('#NextSellPriceGP').val()) || 0.0;
    //     // if(sell == 0){
    //         if(gp == 0){
    //             $('#NextSellPriceGP').val("<?= $defaultgp ?>");
    //         }
    //         NextGPChange();
    //     // }else{
    //         // NextSellPriceChange();
    //     // }

    // });

</script>
<?= $this->endSection() ?>