<?=$this->extend("layouts/default");?>
<?=$this->section("title");?>Coffee Quality Control Checklists<?=$this->endSection();?>

<?=$this->section("header");?>
<link rel="stylesheet" href="<?=base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css');?>" />
<link rel="stylesheet" href="<?=base_url('/js/tabulator-master/dist/css/tabulator_simple.css');?>" />

<script type='text/javascript' src="<?=base_url('/js/jquery/jquery-3.7.1.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/luxon.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/tabulator-master/dist/js/tabulator.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js');?>"></script>
<link rel="stylesheet" href="<?=base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">
<script type='text/javascript' src="<?=base_url('/js/htmx/htmx.min.js');?>"></script>
<?=$this->endSection();?>

<?=$this->section("content");?>

<input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

<div id="res"></div>

<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Coffee Quality Control Checklists",
        "controller" => "Production",
        "links" => [
            "New" =>  ["url" => url_to("Production::new"), "auth_check" => true]
        ]
    ]
) ?>

<?=view("layouts/tabulatorgrid");?>

<script type='text/javascript'>
    var rowMenu = [{
        label:"<i class='fas fa-trash'></i> Delete Row",
        action:function(e, row){
            e.preventDefault();
            var batch_number = row.getCell('batch_number').getValue();
            DayPilot.Modal.confirm("DELETE Quality Checklist, batch number: "+batch_number+"?",
            { theme: "modal_rounded" }).then(function(args) {
//            console.log(args.result);
              var productionid = row.getCell('ProductionID').getValue();
            if(args.result){
                let csrfField = document.getElementById('csrfcode');
                let htmxpath = "<?= base_url("production/delete")?>";
                let csrfname = csrfField.name;
                let csrfval = csrfField.value;
                let success = 0;
                let vals = {};
                vals['ProductionID'] = productionid;
                vals[csrfname] = csrfval;
                htmx.ajax('POST',
                    htmxpath,
                    {
                        target: "#res",
                        swap: 'none',
                        handler: (_, response) => {
                            //console.log(response.xhr.response);
                            res = JSON.parse(response.xhr.response);
                            success = res.success;
                            //console.log(success);
                            //console.log(res.token);
                            $('#csrfcode').val(res.token);
                            if(success == 1){
                                //console.log(success);
                                row.delete();
                            }else{
                                DayPilot.Modal.alert("Something went wrong. I can't delete this checklist",
                                { theme: "modal_rounded" });
                            }
                        },
                        values: vals
                    }
                );
            }
        });
        }
    }];

//event.detail.headers['X-CSRFToken'] = '{{ csrf_token }}';
    var tabtable = new Tabulator('#wrapper', {
        initialSort:[
            {column:"check_date", dir:"desc"},
        ],
        data: [
            <?php foreach ($productions as $production): ?>
                <?="{";?>
                <?="ProductionID:$production->ProductionID,";?>
                <?="batch_number:'" . addslashes($production->batch_number) . "',";?>
                <?="coffee_name:'" . addslashes($production->coffee_name) . "',";?>
                <?="check_date:'$production->check_date',";?>
                <?="checked_by:'" . addslashes($production->checked_by) . "',";?>
                <?="qty_requested:$production->qty_requested,";?>
                <?="qty_produced:'$production->qty_produced',";?>
                <?="final_qc_approval:'" . addslashes($production->final_qc_approval) . "',";?>
                <?="lastupdated:'$production->lastupdated',";?>
                <?="updatedby:'" . addslashes($production->username) . "',";?>
                <?="},";?>
                <?=chr(13) . chr(10);?>
            <?php endforeach;?>
        ],
        layout: "fitDataStretch",
        pagination: false,
        tooltips: true,
        <?php
            if (auth()->user()->inGroup('admin')){
                echo "rowContextMenu: rowMenu,";
            }
        ?>
        columns: [{
                title: "ProductionID",
                field: "ProductionID",
                sorter: "number",
                width: 150,
                visible: false,
            }, {
                title: "Batch Number",
                field: "batch_number",
                sorter: "string",
                hozAlign: "left",
                width: 200,
                headerFilter: "input",
                //headerFilterParams:{valuesLookup:true, clearable:true},
                responsive: 0,
            },
            {
                title: "Coffee(Recipe)",
                field: "coffee_name",
                sorter: "string",
                hozAlign: "left",
                width: 200,
                headerFilter: "list",
                responsive: 0,
                headerFilterParams: {
                    valuesLookup: true,
                    clearable: true
                },
            }, {
                title: "Check Date",
                field: "check_date",
                hozAlign: "left",
                responsive: 4,
                formatter: "datetime",
                formatterParams: {
                    inputFormat: "yyyy-LL-dd TT",
                    outputFormat: "dd/MM/yyyy",
                    invalidPlaceholder: "(invalid date)",
                    timezone: "system",
                },
                sorter: "datetime",
                sorterParams: {
                    format: "yyyy-MM-dd HH:mm:ss",
                    alignEmptyValues: "top",
                }
            }, {
                title: "Checked by",
                field: "checked_by",
                sorter: "string",
                hozAlign: "left",
                headerFilter: "input",
                responsive: 0,
                headerFilter: "list",
                headerFilterParams: {
                    valuesLookup: true,
                    clearable: true
                },
            }, {
                title: "Qty Requested",
                field: "qty_requested",
                sorter: "number",
                hozAlign: "right",
                responsive: 0,
            }, {
                title: "Qty Produced",
                field: "qty_produced",
                sorter: "number",
                hozAlign: "right",
                responsive: 0,
            },{
                title: "Final QC Approval",
                field: "final_qc_approval",
                sorter: "string",
                hozAlign: "left",
                headerFilter: "list",
                headerFilterParams: {
                    valuesLookup: true,
                    clearable: true
                },
                responsive: 3,
            },{
                title: "Last Updated",
                field: "lastupdated",
                hozAlign: "left",
                responsive: 4,
                formatter: "datetime",
                formatterParams: {
                    inputFormat: "yyyy-LL-dd TT",
                    outputFormat: "dd/MM/yyyy TT",
                    invalidPlaceholder: "(invalid date)",
                    timezone: "system",
                },
                sorter: "datetime",
                sorterParams: {
                    format: "yyyy-MM-dd HH:mm:ss",
                    alignEmptyValues: "top",
                }
            },{
                title: "Last Update By",
                field: "updatedby",
                sorter: "string",
                hozAlign: "left",
                headerFilter: "list",
                headerFilterParams: {
                    valuesLookup: true,
                    clearable: true
                },
                responsive: 3,
            },
        ],
    }).on('rowClick', function(e, row) {
        window.location = '<?=base_url("production") . "/";?>' + row.getCell('ProductionID').getValue() + '/edit';
    });



</script>


<?=$this->endSection();?>

<?=$this->section("javascript");?>
<?=$this->endSection();?>
