<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
<link rel="stylesheet" href="<?= base_url('/css/production.css') . '?' . rand() ?>" />
<script type="text/javascript" src="<?php echo base_url('js/jquery/jquery-3.7.1.min.js'); ?>"></script>
<script type="text/javascript" src="<?php echo base_url('js/jquery-ui-1.14.1/jquery-ui.min.js'); ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/html-duration-picker.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('js/htmx/htmx.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js'); ?>"></script>
<link rel="stylesheet" href="<?= base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">
<link href="<?= base_url('js/lightbox2/dist/css/lightbox.css') ?>" rel="stylesheet" />
<style>
    .scroll-btn {
        min-width: 0;
        background-color: unset;
        color: unset;
        border-radius: unset;
    }

    .inputchange {
        border-style: none;
    }
    input:disabled {
        color: #1E1E1E;
    }
    input[disabled][type="radio"]:checked::before {
    content: "\25C9";
    position: relative;
    z-index: 100;
    top: -3px;
    left: .5px;
    }

    input[type="radio"]:checked + .option-label, input[type="checkbox"]:checked + .option-label {
      font-weight: 600;
    }

    input[disabled][type="checkbox"]:checked::before {
        content: "\2611";
        position: relative;
        background: white;
        font-size: 17px;
        top: -7px;
        left: .5px;
        font-weight: 600;
    }

    .tooltip {
        position: relative;
        display: inline-block;
        border-bottom: 1px dotted black;
    }

    .tooltip .tooltiptext {
        visibility: hidden;
        width: 120px;
        background-color: black;
        color: #fff;
        text-align: center;
        border-radius: 6px;
        padding: 5px 0;

        /* Position the tooltip */
        position: absolute;
        z-index: 1;
        bottom: 100%;
        left: 50%;
        margin-left: -60px;
    }

    .tooltip:hover .tooltiptext {
        visibility: visible;
    }

    li {
      display: list-item;
      list-style-position: inside;
    }
</style>


<input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

<main>
    <div id="res"></div>
    <div class="outer">
        <div style="grid-column: 1;  grid-row: 1; ">
            <div style="display: grid; grid-template-columns: 80% 20%; padding: 0; margin:0; ">
                <p class="s1" style="padding-top: 11pt;padding-left: 10pt;text-indent: 0pt;text-align: left;">COFFEE QUALITY CONTROL CHECKLIST</p>
                <div>
                    <a class="/*button*/" href="<?= url_to('Production::index') ?>"><img style="width: 15vw;" src="<?= base_url('/images/RoastPRO-02.jpg') ?>" alt=""></a>
                </div>
            </div>
            <div class="coffee-quality-control-checklist">
                <!-- 3 columns -->
                <div style="grid-column:1 /SPAN 2;">
                    <div style="display:grid; gap:0; grid-column: 80% 20%; padding: 0; margin: 0;">
                        <div style="grid-column: 1; grid-row: 1;">
                            <p class="s2" style="padding-top: 2pt;padding-left: 5pt;text-indent: 0pt;text-align: left; width:20rem;">Coffee Name:
                                <select class="cell-required disableifapproved" name="coffee_name" id="coffee_name" required onchange="getGreenCoffees()">
                                    <?php foreach ($recipes as $recipe): ?>
                                        <option value="<?= $recipe->RecipeName ?>"
                                            <?= $recipe->RecipeName == $production->coffee_name ? 'selected' : '';  ?>>
                                            <?= $recipe->RecipeName ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </p>
                        </div>
                        <div style="grid-column: 1; grid-row: 2;">
                            <p class="s2" style="padding-top: 2pt;padding-left: 5pt;text-indent: 0pt;text-align: left;">
                                Batch Number:
                                <input class="grid-cell cell-required disableifapproved" style="width: 20rem;" type="text" name="batch_number" id="batch_number" value="<?= old("batch_number", esc($production->batch_number)) ?>" required onchange="batch_changed()">
                            </p>
                        </div>
                        <div style="grid-column: 2; grid-row: 1 / SPAN 2;">
                            <?php if($image->ImageName !== null): ?>
                                <a id = "recipe-image-a" href="<?= $image->ImageName ?>" data-lightbox="pack-image" data-title=".">
                                    <img id="recipe-image-img" class="example-image" src="<?= $image->ImageName ?>" alt="<?= $image->ImageID ?>" style="max-width:5vw; max-height:5vw;">
                                </a>
                            <?php else: ?>
                                <a id = "recipe-image-a" href="#" data-lightbox="pack-image" data-title=".">
                                    <img id="recipe-image-img" class="example-image" src="" alt="" style="max-width:5vw; max-height:5vw;">
                                </a>
                            <?php endif;?>
                        </div>
                    </div>

                    <?= $certifications['certcheckbox'] ?>
                </div>
                <div style="grid-column:3;">
                    <div style="display:grid; grid-template-columns:repeat(2,128px);">
                        <div class="s2" style="grid-column: 1; grid-row:1; padding: 0 20px;">
                            Date:
                        </div>
                        <div style="grid-column:2; grid-row:1;">
                            <input class="s2 grid-cell cell-required disableifapproved" type="date" name="check_date" id="check_date" value="<?= old("check_date", date_format(date_create($production->check_date), 'Y-m-d')) ?>" required>
                        </div>

                        <div class="s2" style="grid-column: 1; grid-row:2; padding: 0 20px;">
                            Checked by:
                        </div>
                        <div style="grid-column:2; grid-row:2;">
                            <input class="s2 grid-cell cell-required disableifapproved" type="text" name="checked_by" id="checked_by" value="<?= old("checked_by", esc($production->checked_by)) ?>" required>
                        </div>

                        <div class="s2" style="grid-column: 1; grid-row:3; padding: 0 20px;">
                            Qty Requested:
                        </div>
                        <div style="grid-column:2; grid-row:3;">
                            <div id="wastepercent" hidden>0</div>
                            <input class="s2 grid-cell cell-required disableifapproved" type="number" name="qty_requested" id="qty_requested" step="0.01" placeholder="0.00" value="<?= old("qty_requested", esc($production->qty_requested)) ?>" required onblur="blurqty_requested();">
                        </div>

                        <div class="s2" style="grid-column: 1; grid-row:4; padding: 0 20px;">
                            Qty Produced:
                        </div>
                        <div style="grid-column:2; grid-row:4;">
                            <input class="s2 grid-cell disableifapproved" type="number" name="qty_produced" id="qty_produced" step="0.01" placeholder="0.00" value="<?= old("qty_produced", esc($production->qty_produced)) ?>">
                        </div>
                    </div>
                </div>
            </div>

            <p class="s4" style="padding-top: 4pt;padding-left: 29pt;text-indent: -17pt;text-align: left;">1. Green Coffee Inspection (Before Roasting)</p>
            <div class="green-coffee-inspection">
                <div style="grid-column:1; grid-row:1;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Green Coffee</p>
                </div>
                <div style="grid-column:2; grid-row:1;">
                    <div id="ratiototal"  hidden>0</div>
                    <p class="s3" style="padding-top: 5pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Qty Used</p>
                </div>
<!--                 <div style="grid-column:3; grid-row:1;">
                    <p class="s3" style="padding-left: 11pt;text-indent: 0pt;text-align: left;">Moisture Level</p>
                    <p style="padding-left: 11pt;text-indent: 0pt;text-align: left;">(Target: 10-12%)</p>
                </div>
 -->
                <?= $certifications['certheader'] ?>

<!--                 <div style="grid-column:5; grid-row:1;">
                    <p class="s3" style="text-align: center;">Visual Check</p>
                    <p class="v-small" style="text-align: center;">(Defects, Inconsistencies, Foreign Matter)</p>
                    <div class="v-small grid-cell-center " style="display: grid; grid-template-columns:repeat(2,auto); gap:0;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:1;">
                    <p class="s3" style="text-align: center;">Smell Check</p>
                    <p class="v-small" style="text-align: center;">(Fresh, No Off-Odors)</p>
                    <div class="v-small grid-cell-center " style="display: grid; grid-template-columns:repeat(2,auto); gap:0;">
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
 -->
                <div style="grid-column:1; grid-row:2;">
                    <select class="s3 grid-cell cell-required inputchange disableifapproved" name="green_coffee1" id="green_coffee1" required oninput="getCertsForCoffee('green_coffee1');">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee1 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:3;">
                    <select class="s3 grid-cell inputchange disableifapproved" name="green_coffee2" id="green_coffee2" oninput="getCertsForCoffee('green_coffee2');">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee2 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:4;">
                    <select class="s3 grid-cell inputchange disableifapproved" name="green_coffee3" id="green_coffee3" onchange="getCertsForCoffee('green_coffee3');">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee3 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:5;">
                    <select class="s3 grid-cell inputchange disableifapproved" name="green_coffee4" id="green_coffee4" onchange="getCertsForCoffee('green_coffee4');">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee4 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div style="grid-column:1; grid-row:6;">
                    <select class="s3 grid-cell inputchange disableifapproved" name="green_coffee5" id="green_coffee5" onchange="getCertsForCoffee('green_coffee5');">
                        <?php foreach ($coffees as $coffee): ?>
                            <option value="<?= $coffee->InputName ?>"
                                <?= $coffee->InputName == $production->green_coffee5 ? 'selected' : '';  ?>>
                                <?= $coffee->InputName ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div style="grid-column:2; grid-row:2;">
                    <div id="ratio1" hidden></div>
                    <input class="grid-cell s3 qtychange disableifapproved" type="number" name="qty_used1" id="qty_used1" step="0.01" placeholder="0.00" value="<?= old("qty_used1", esc($production->qty_used1)) ?>">
                </div>
                <div style="grid-column:2; grid-row:3;">
                    <div id="ratio2" hidden></div>
					<input class="grid-cell s3 qtychange disableifapproved" type="number" name="qty_used2" id="qty_used2" step="0.01" placeholder="0.00" value="<?= old("qty_used2", esc($production->qty_used2)) ?>">
                </div>
                <div style="grid-column:2; grid-row:4;">
                    <div id="ratio3" hidden></div>
					<input class="grid-cell s3 qtychange disableifapproved" type="number" name="qty_used3" id="qty_used3" step="0.01" placeholder="0.00" value="<?= old("qty_used3", esc($production->qty_used3)) ?>">
                </div>
                <div style="grid-column:2; grid-row:5;">
                    <div id="ratio4" hidden></div>
					<input class="grid-cell s3 qtychange disableifapproved" type="number" name="qty_used4" id="qty_used4" step="0.01" placeholder="0.00" value="<?= old("qty_used4", esc($production->qty_used4)) ?>">
                </div>
                <div style="grid-column:2; grid-row:6;">
                    <div id="ratio5" hidden></div>
					<input class="grid-cell s3 qtychange disableifapproved" type="number" name="qty_used5" id="qty_used5" step="0.01" placeholder="0.00" value="<?= old("qty_used5", esc($production->qty_used5)) ?>">
                </div>

<!--                 <div style="grid-column:3; grid-row:2;">
                    <input class="grid-cell s3" type="number" name="moisture_level1" id="moisture_level1" value="<?= old("moisture_level1", esc($production->moisture_level1)) ?>">
                </div>
                <div style="grid-column:3; grid-row:3;">
                    <input class="grid-cell s3" type="number" name="moisture_level2" id="moisture_level2" value="<?= old("moisture_level2", esc($production->moisture_level2)) ?>">
                </div>
                <div style="grid-column:3; grid-row:4;">
                    <input class="grid-cell s3" type="number" name="moisture_level3" id="moisture_level3" value="<?= old("moisture_level3", esc($production->moisture_level3)) ?>">
                </div>
                <div style="grid-column:3; grid-row:5;">
                    <input class="grid-cell s3" type="number" name="moisture_level4" id="moisture_level4" value="<?= old("moisture_level4", esc($production->moisture_level4)) ?>">
                </div>
                <div style="grid-column:3; grid-row:6;">
                    <input class="grid-cell s3" type="number" name="moisture_level5" id="moisture_level5" value="<?= old("moisture_level5", esc($production->moisture_level5)) ?>">
                </div>
 -->                <!-- <div id="cert-coffees" style="padding: 0; margin: 0; grid-column:4; grid-row:2 / SPAN 6; display: grid; grid-template-columns: repeat(1, auto); gap: 0; padding: 0; margin: 0;"> -->

                <?php foreach ($certifications['certcheck'] as $certcheck): ?>
                    <?= $certcheck->certcheck ?>
                <?php endforeach; ?>

                <!-- </div> -->

<!--                 <div style="grid-column:5; grid-row:2;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,auto);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check1" id="visual-check-pass1" <?= $production->visual_check1 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check1', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check1" id="visual-check-fail1" <?= $production->visual_check1 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check1', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:3;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check2" id="visual-check-pass2" <?= $production->visual_check2 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check2', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check2" id="visual-check-fail2" <?= $production->visual_check2 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check2', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:4;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check3" id="visual-check-pass3" <?= $production->visual_check3 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check3', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check3" id="visual-check-fail3" <?= $production->visual_check3 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check3', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:5;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check4" id="visual-check-pass4" <?= $production->visual_check4 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check4', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check4" id="visual-check-fail4" <?= $production->visual_check4 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check4', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:6;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="visual_check5" id="visual-check-pass5" <?= $production->visual_check5 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check5', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="visual_check5" id="visual-check-fail5" <?= $production->visual_check5 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check5', 0) ?>>
                    </div>
                </div>

                <div style="grid-column:6; grid-row:2;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check1" id="smell-check-pass1" <?= $production->smell_check1 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check1', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check1" id="smell-check-fail1" <?= $production->smell_check1 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check1', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:3;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check2" id="smell-check-pass2" <?= $production->smell_check2 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check2', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check2" id="smell-check-fail2" <?= $production->smell_check2 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check2', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:4;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check3" id="smell-check-pass3" <?= $production->smell_check3 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check3', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check3" id="smell-check-fail3" <?= $production->smell_check3 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check3', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:5;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check4" id="smell-check-pass4" <?= $production->smell_check4 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check4', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check4" id="smell-check-fail4" <?= $production->smell_check4 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check4', 0) ?>>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:6;">
                    <div style="padding:0; display:grid; gap:0; grid-template-columns:repeat(2,1fr);">
                        <input class="grid-cell-checkbox" type="radio" name="smell_check5" id="smell-check-pass5" <?= $production->smell_check5 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check5', 1) ?>>
                        <input class="grid-cell-checkbox" type="radio" name="smell_check5" id="smell-check-fail5" <?= $production->smell_check5 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check5', 0) ?>>
                    </div>
                </div>
 -->
                <div class="s3" style="grid-column:1;grid-row:7;">Comments:</div>
                <div style="grid-column: 2 / SPAN 6; grid-row:7;"><input class="grid-cell s3 disableifapproved" type="text" name="green_coffee_comments" id="green_coffee_comments" value="<?= old("green_coffee_comments", esc($production->green_coffee_comments)) ?>"></div>

            </div>

            <div class="roasting">
                <div style="grid-column:1;">
                    <p class="s4" style="padding-top: 4pt;padding-left: 33pt;text-indent: -22pt;text-align: left;">2. Roasting Process Checks</p>
                    <div class="roasting-process-checks">
                        <div class="s3 grid-cell-center" style="grid-column:1; grid-row:1;margin-top:12px;">
                            Diedrich CR35 <input class="grid-cell-checkbox disableifapproved" type="checkbox" name="diedrich_cr35[]" id="diedrich_cr35" value="1" <?= $production->diedrich_cr35 ? 'checked' : '' ?>>
                        </div>
                        <div class="s3 grid-cell-center" style="grid-column:2; grid-row:1;margin-top:12px;">
                            Joper 120 <input class="grid-cell-checkbox disableifapproved" type="checkbox" name="joper_120[]" id="joper_120" value="1" <?= $production->joper_120 ? 'checked' : '' ?>>
                        </div>
                        <div class="s3" style="grid-column:3; grid-row:1;">
                            Profile Used <br /> <input class="grid-cell inputchange disableifapproved" type="text" name="profile_used" id="profile_used" value="<?= old("profile_used", esc($production->profile_used)) ?>">
                        </div>
                        <div class="s3" style="grid-column:1; grid-row:2;">
                            End Temp Target:<br />
                            <p class="v-small">oC</p><input class="grid-cell disableifapproved" type="number" name="end_temp_target" id="end_temp_target" step="0.01" placeholder="0.00" value="<?= old("end_temp_target", $production->end_temp_target) ?>">
                        </div>
                        <div class="s3" style="grid-column:2; grid-row:2;">
                            Actual:<br />
                            <p class="v-small">oC</p><input class="grid-cell disableifapproved" type="number" name="actual_temp" id="actual_temp" step="0.01" placeholder="0.00" value="<?= old("actual_temp", $production->actual_temp) ?>">
                        </div>
                        <div class="s3" style="grid-column:3; grid-row:2;">
                            First Crack Timing<br />
                            <p class="v-small">(hh:mm:ss):</p><input class="grid-cell html-duration-picker disableifapproved" name="first_crack_timing" id="first_crack_timing" value="<?= old("first_crack_timing", $production->first_crack_timing) ?>">
                        </div>
                        <!-- <div class="s3 grid-cell-flex-center" style="grid-column:1 / SPAN 2; grid-row:3;">
                            Colour Analysis (Agtron Number)
                        </div>
                        <div class="s3" style="grid-column:3; grid-row:3;" class="grid-cell disableifapproved">
                            <input class="grid-cell inputchange disableifapproved" type="number" name="colour_analysis" id="colour_analysis" step="1" placeholder="0" value="<?= old("colour_analysis", $production->colour_analysis)?>" onchange="showRoastName();">
                            <div  id="roast_colour_name" class="grid-cell inputchange v-small"></div>
                        </div> -->
                    </div>
                </div>
                <div style="grid-column:2;">
                    <p class="s4" style="padding-top: 4pt;padding-left: 40pt;text-indent: -22pt;text-align: left;">3. Post-Roast Quality Checks</p>
                    <div class="post-roast-quality-check">
                        <div style="grid-column: 1; grid-row:1;">
                            <div style="display: grid; grid-template-columns: 80% 20%;">
                                <div style="grid-column:2; grid-row:1;">
                                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                                        <div class="v-small grid-cell-checkbox">Pass</div>
                                        <div class="v-small grid-cell-checkbox">Fail</div>
                                    </div>
                                </div>

                                <div class="s3" style="grid-column:1; grid-row:2;">
                                    Bean Appearance <span class="s8">(Even Roast, No Scorching, No Tipping)</span>
                                </div>
                                <div style="grid-column:2; grid-row:2;">
                                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                                        <input class="grid-cell-checkbox disableifapproved" type="radio" name="bean_apperance" id="bean_apperance-pass" <?= $production->bean_apperance == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('bean_apperance', 1) ?>>
                                        <input class="grid-cell-checkbox disableifapproved" type="radio" name="bean_apperance" id="bean_apperance-fail" <?= $production->bean_apperance == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('bean_apperance', 0) ?>>
                                    </div>
                                </div>

                                <div class="s3" style="grid-column:1; grid-row:3; place-self: center;">
                                    Colour Analysis (Agtron Number) expected <span class="inputchange" id="roastcolournodisplay"><?= $production->roastcolourno ?></span>
                                    <input type="hidden" name="roastcolourno" id="roastcolourno" value="<?= $production->roastcolourno ?>">
                                </div>
                                <div class="s3" style="grid-column:2; grid-row:3;" class="grid-cell disableifapproved">
                                    <input class="grid-cell disableifapproved" type="number" name="colour_analysis" id="colour_analysis" step="1" placeholder="0" value="<?= old("colour_analysis", $production->colour_analysis)?>" onchange="showRoastName();">
                                    <div  id="roast_colour_name" class="grid-cell inputchange v-small"></div>
                                </div>

                                <!-- <div class="s3" style="grid-column:1; grid-row:3;">
                                    Moisture Level After Roasting (%):
                                </div>
                                <div class="s3" style="grid-column:2; grid-row:3;">
                                    <input class="grid-cell disableifapproved" type="number" name="moisture_level_after_roasting" id="moisture_level_after_roasting" step="0.01" placeholder="0.00" value="<?= old("moisture_level_after_roasting", $production->moisture_level_after_roasting) ?>">
                                </div> -->
                            </div>
                            <div class="s3" style="grid-column:1 / SPAN 2; grid-row:4;">
                                Comments:
                            </div>
                            <div class="s3" style="grid-column:1 / SPAN 2; grid-row:5;">
                                <textarea class="grid-cell disableifapproved" name="post_roast_comments" id="post_roast_comments" rows="3"><?= old("post_roast_comments", esc($production->post_roast_comments)) ?></textarea>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


            <!-- 7 columns -->
            <p class="s4 showhidecupping" style="padding-left: 34pt;text-indent: -23pt;text-align: left;">4. Cupping &amp; Sensory Analysis</p>
            <div id="roastfromnumber" style="display: none;">FROM NUMBER</div>
            <div id="roasttonumber" style="display: none;">TO NUMBER</div>
            <div class="cupping showhidecupping">
                <div style="grid-column: 2; grid-row: 1;">
                    <p class="v-small">Yes
                        No
                    </p>
                </div>

                <div style="grid-column:1; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt; text-indent: 0pt;text-align: left;">Fragrance/Aroma</p>
                    <div class="v-small range-val" id="fragranceVal">
                        <?= old("fragrance", $production->fragrance) ?>
                    </div>
                    <input class="disableifapproved" type="range" min="6" max="10" name="fragrance" id="fragrance" list="range-6-10" step="0.25" value="<?= old("fragrance", $production->fragrance) ?>" onchange="showRangeValue('fragrance', 'fragranceVal');">
                    <datalist id="range-6-10" class="range-6-10">
                        <option value="6">6</option>
                        <option value="6.25"></option>
                        <option value="6.5"></option>
                        <option value="6.75"></option>
                        <option value="7">7</option>
                        <option value="7.25"></option>
                        <option value="7.5"></option>
                        <option value="7.75"></option>
                        <option value="8">8</option>
                        <option value="8.25"></option>
                        <option value="8.5"></option>
                        <option value="8.75"></option>
                        <option value="9">9</option>
                        <option value="9.25"></option>
                        <option value="9.5"></option>
                        <option value="9.75"></option>
                        <option value="10">10</option>
                    </datalist>
                </div>
                <div style="grid-column:2; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Flavour</p>
                    <div class="v-small range-val" id="flavourVal">
                        <?= old("flavour", $production->flavour) ?>
                    </div>
                    <input class="disableifapproved" type="range" min="6" max="10" name="flavour" id="flavour" list="range-6-10" step="0.25" value="<?= old("flavour", $production->flavour) ?>" onchange="showRangeValue('flavour', 'flavourVal');">
                    <datalist id="range-6-10" class="range-6-10">
                        <option value="6">6</option>
                        <option value="6.25"></option>
                        <option value="6.5"></option>
                        <option value="6.75"></option>
                        <option value="7">7</option>
                        <option value="7.25"></option>
                        <option value="7.5"></option>
                        <option value="7.75"></option>
                        <option value="8">8</option>
                        <option value="8.25"></option>
                        <option value="8.5"></option>
                        <option value="8.75"></option>
                        <option value="9">9</option>
                        <option value="9.25"></option>
                        <option value="9.5"></option>
                        <option value="9.75"></option>
                        <option value="10">10</option>
                    </datalist>
                </div>
                <div style="grid-column:3; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Aftertaste</p>
                    <div class="v-small range-val" id="aftertasteVal">
                        <?= old("aftertaste", $production->aftertaste) ?>
                    </div>
                    <input class="disableifapproved" type="range" min="6" max="10" name="aftertaste" id="aftertaste" list="range-6-10" step="0.25" value="<?= old("aftertaste", $production->aftertaste) ?>" onchange="showRangeValue('aftertaste', 'aftertasteVal');">
                    <datalist id="range-6-10" class="range-6-10">
                        <option value="6">6</option>
                        <option value="6.25"></option>
                        <option value="6.5"></option>
                        <option value="6.75"></option>
                        <option value="7">7</option>
                        <option value="7.25"></option>
                        <option value="7.5"></option>
                        <option value="7.75"></option>
                        <option value="8">8</option>
                        <option value="8.25"></option>
                        <option value="8.5"></option>
                        <option value="8.75"></option>
                        <option value="9">9</option>
                        <option value="9.25"></option>
                        <option value="9.5"></option>
                        <option value="9.75"></option>
                        <option value="10">10</option>
                    </datalist>
                </div>
                <div style="grid-column:4; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Acidity <span class="v-small"> (Intensity)</span></p>
                    <div class="v-small range-val" id="acidityVal">
                        <?= old("acidity", $production->acidity) ?>
                    </div>
                    <input class="disableifapproved" type="range" min="0" max="4" name="acidity" id="acidity" list="acidity_list" step="1" value="<?= old("acidity", $production->acidity) ?>" onchange="showRangeValue('acidity', 'acidityVal');">
                    <datalist id="acidity_list" class="acidity-list">
                        <option value="0">High</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Low</option>
                    </datalist>
                </div>
                <div style="grid-column:5; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Body <span class="v-small"> (Level)</span></p>
                    <div class="v-small range-val" id="bodyVal">
                        <?= old("body", $production->body) ?>
                    </div>
                    <input class="disableifapproved" type="range" min="0" max="4" name="body" id="body" list="body-list" step="1" value="<?= old("body", $production->body) ?>" onchange="showRangeValue('body', 'bodyVal');">
                    <datalist id="body-list" class="body-list">
                        <option value="0">Heavy</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Thin</option>
                    </datalist>
                </div>
                <div style="grid-column:6; grid-row:3;padding:0 1px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 11pt;text-indent: 0pt;text-align: left;">Clean Cup <span class="v-small"> (Level)</span></p>
                    <div class="v-small range-val" id="clean_cupVal">
                        <?= old("clean_cup", $production->clean_cup) ?>
                    </div>
                    <input class="disableifapproved" type="range" min="0" max="4" name="clean_cup" id="clean_cup" list="clean-cup-list" step="1" value="<?= old("clean_cup", $production->clean_cup) ?>" onchange="showRangeValue('clean_cup', 'clean_cupVal');">
                    <datalist id="clean-cup-list" class="clean-cup-list">
                        <option value="0">Tainted</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Clean</option>
                    </datalist>
                </div>
                <div style="grid-column:7; grid-row:3;padding:0 2px;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 4pt;text-indent: 0pt;text-align: left;">Sweetness <span class="v-small"> (Level)</span></p>
                    <div class="v-small range-val" id="sweetnessVal">
                        <?= old("sweetness", $production->sweetness) ?>
                    </div>
                    <input class="disableifapproved" type="range" min="0" max="4" name="sweetness" id="sweetness" list="sweetness-list" step="1" value="<?= old("sweetness", $production->sweetness) ?>" onchange="showRangeValue('sweetness', 'sweetnessVal');">
                    <datalist id="sweetness-list" class="sweetness-list">
                        <option value="0">Sour</option>
                        <option value="1"></option>
                        <option value="2">|</option>
                        <option value="3"></option>
                        <option value="4">Sweet</option>
                    </datalist>
                </div>
            </div>

            <p class="s4" style="padding-left: 34pt;text-indent: -23pt;text-align: left;">5. Packaging &amp; Grinding QC</p>
            <div class="packaging">
                <div style="grid-column: 1; grid-row:1;">
                    <p class="s3">(Random check on 1 in every 100 bags)</p>
                </div>
                <div style="grid-column:3; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div style="grid-column: 1 / SPAN 2;">Bag Seals
                            <?php if( !($packingimages['BAGSEAL']['ImageName'] == null || empty($packingimages['BAGSEAL']['ImageName']))):  ?>
                            <a id = "bagseal-image" href="<?= $packingimages['BAGSEAL']['ImageName'] ?>" data-lightbox="bagseal-image" data-title=".">
                                <i class="material-icons tooltip" style="font-size:12px;">
                                    help
                                    <span class="tooltiptext"> <img src="<?= $packingimages['BAGSEAL']['ImageName'] ?>" alt="Box End Label">
                                        <p style="color: white;">Click ? for larger picture</p>
                                    </span>
                                </i>
                            </a>
                            <?php endif; ?>
                        </div>
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:4; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div style="grid-column: 1 / SPAN 2;">Security Labels
                            <?php if( !($packingimages['BAGLABEL']['ImageName'] == null || empty($packingimages['BAGLABEL']['ImageName']))):  ?>
                            <a id = "baglabel-image" href="<?= $packingimages['BAGLABEL']['ImageName'] ?>" data-lightbox="baglabel-image" data-title=".">
                                <i class="material-icons tooltip" style="font-size:12px;">
                                    help
                                    <span class="tooltiptext"> <img src="<?= $packingimages['BAGLABEL']['ImageName'] ?>" alt="Box End Label">
                                        <p style="color: white;">Click ? for larger picture</p>
                                    </span>
                                </i>
                            </a>
                            <?php endif; ?>
                        </div>
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:5; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div style="grid-column: 1 / SPAN 2;">Exp. Date
                            <?php if( !($packingimages['EXPDATE']['ImageName'] == null || empty($packingimages['EXPDATE']['ImageName']))):  ?>
                            <a id = "expdate-image" href="<?= $packingimages['EXPDATE']['ImageName'] ?>" data-lightbox="expdate-image" data-title=".">
                                <i class="material-icons tooltip" style="font-size:12px;">
                                    help
                                    <span class="tooltiptext"> <img src="<?= $packingimages['EXPDATE']['ImageName'] ?>" alt="Box End Label">
                                        <p style="color: white;">Click ? for larger picture</p>
                                    </span>
                                </i>
                            </a>
                            <?php endif; ?>
                        </div>
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>
                <div style="grid-column:6; grid-row:1;">
                    <div class="s9" style="display: grid; grid-template-columns:repeat(2,auto);text-align:center;">
                        <div style="grid-column: 1 / SPAN 2;">Box End Labels
                            <?php if( !($packingimages['BOXEND']['ImageName'] == null || empty($packingimages['BOXEND']['ImageName']))):  ?>
                            <a id = "boxend-image" href="<?= $packingimages['BOXEND']['ImageName'] ?>" data-lightbox="boxend-image" data-title=".">
                                <i class="material-icons tooltip" style="font-size:12px;">
                                    help
                                    <span class="tooltiptext"> <img src="<?= $packingimages['BOXEND']['ImageName'] ?>" alt="Box End Label">
                                        <p style="color: white;">Click ? for larger picture</p>
                                    </span>
                                </i>
                            </a>
                            <?php endif; ?>
                        </div>
                        <div>Pass</div>
                        <div>Fail</div>
                    </div>
                </div>

                <div style="grid-column: 1 / SPAN 2; grid-row:2;">
                    <p class="s3" style="padding-top: 4pt;padding-left: 13pt;text-indent: 0pt;text-align: left; place-self: center;">Packaging Integrity Check (Seals, Labels, Expiry Date)</p>
                </div>
                <div style="grid-column: 3; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input class="disableifapproved" id="quality_check_1" name="quality_check_1" type="radio" style="vertical-align: middle;" <?= $production->quality_check_1 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_1', 1) ?> />
                        <input class="disableifapproved" id="quality_check_1" name="quality_check_1" type="radio" style="vertical-align: middle;" <?= $production->quality_check_1 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_1', 0) ?> />
                    </div>
                </div>

                <div style="grid-column: 4; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input class="disableifapproved" id="quality_check_2" name="quality_check_2" type="radio" style="vertical-align: middle;" <?= $production->quality_check_2 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_2', 1) ?> />
                        <input class="disableifapproved" id="quality_check_2" name="quality_check_2" type="radio" style="vertical-align: middle;" <?= $production->quality_check_2 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_2', 0) ?> />
                    </div>
                </div>

                <div style="grid-column: 5; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input class="disableifapproved" id="quality_check_3" type="radio" name="quality_check_3" style="vertical-align: middle;" <?= $production->quality_check_3 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_3', 1) ?>>
                        <input class="disableifapproved" id="quality_check_3" type="radio" name="quality_check_3" style="vertical-align: middle;" <?= $production->quality_check_3 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_3', 0) ?>>
                    </div>
                </div>

                <div style="grid-column: 6; grid-row:2;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <input class="disableifapproved" id="quality_check_4" type="radio" name="quality_check_4" style="vertical-align: middle;" <?= $production->quality_check_4 == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('quality_check_4', 1) ?>>
                        <input class="disableifapproved" id="quality_check_4" type="radio" name="quality_check_4" style="vertical-align: middle;" <?= $production->quality_check_4 == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('quality_check_4', 0) ?>>
                    </div>
                </div>

                <div class="s3" style="grid-column: 1 / SPAN 6; grid-row:4; border: #1E1E1E; border-width: 1px; border-style: solid; border-radius: 5px; margin-top:10px; margin-bottom:10px; padding-top:5px; padding-left:5px; padding-bottom:5px;">
                    <div class="verdana8">
                        <div class="s3">Weight Control</div>
                        <div>Bridge Coffee Roasters packs to the minimum weight system and within Weights and Measures the following procedure and checks are carried out to ensure that finished products are packed to they contain at least the quantity displayed on the label.</div>
                        <ol type="1">
                            <li>From each production run the following weight checks should be carried out and recorded below:
                                <ul style="list-style-type:disc;">
                                    <li>1Kg - 6 samples (1box) and 1 packet from the end of the run</li>
                                    <li>250g - 10 samples (&#189; box) and 1 packet from the end of the run.</li>
                                    <li>227g - 10 samples (&#189; box) and 1 packet from the end of the run.</li>
                                    <li>165g - 10 samples (&#8531; box) and 1 packet from the end of the run.</li>
                                    <li>50g - 10 samples and 1 packet from the end of the run.</li>
                                </ul>
                            </li>
                            <li>Calibrated scales should be used and all the packages should be tared prior to the weight checks</li>
                            <li>If weight checks are found to be under the specified minimum weight then repeat checks are required to ensure the batch produced meets the minimum weight</li>
                        </ol>
                    </div>
                    <div style="display: grid; gap:0; grid-template-columns: repeat(11,68px);">

                        <div style="grid-row:1; grid-column: 1 / SPAN 2;place-self: center;">Batch Code</div>
                        <div style="grid-row:1; grid-column: 3 / SPAN 4;">
                            <input class="grid-cell s3 disableifapproved weightdisableifapproved" name="weight_batch_code" id="weight_batch_code" value="<?= old("weight_batch_code", esc($production->weight_batch_code)) ?>">
                        </div>


                        <div class="tooltip" style="grid-row:1;grid-column: 8 / SPAN 2; place-self: center;">
                            Pack Weight
                            <span class="tooltiptext">Pack weight in grams e.g. 1000,250,227,165</span>
                        </div>
                        <div style="grid-row:1; grid-column: 10 / SPAN 2;">
                            <input class="grid-cell s3 disableifapproved qtychange" type="number" name="weight_pack" id="weight_pack" step="1" placeholder="0" min="0" value="<?= number_format(old("weight_pack", esc($production->weight_pack)), 0,decimal_separator: '.',thousands_separator: '') ?>">
                        </div>


                        <div style="grid-row:2; grid-column: 1 / SPAN 11; border-style:solid; border-width: 1px; padding-top: 5px; padding-bottom: 5px; margin-top: 5px;">
                            <div style="place-self: center;">
                                Weights (g)
                            </div>
                        </div>

                        <div style="grid-row:3; grid-column: 1 /SPAN 10; border-style:solid; border-width: 1px; padding-top: 5px; padding-bottom: 5px;">
                            <div style="place-self: center;">
                                Start of Production
                            </div>
                        </div>

                        <div style="grid-row:3; grid-column: 11; border-style:solid; border-width: 1px; padding-top: 5px; padding-bottom: 5px; ">
                            <div style="place-self: center;">
                                End
                            </div>
                        </div>

                        <div style="grid-row:4; grid-column: 1;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_1" id="weight_1" step="1" min="0" placeholder="0"
                                <?php if($production->weight_1): ?>
                                    value='<?= old("weight_1", number_format(esc($production->weight_1), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>

                        <div style="grid-row:4; grid-column: 2;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_2" id="weight_2" step="1" min="0" placeholder="0"
                                <?php if($production->weight_2): ?>
                                    value='<?= old("weight_2", number_format(esc($production->weight_2), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 3;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_3" id="weight_3" step="1" min="0" placeholder="0"
                                <?php if($production->weight_3): ?>
                                    value='<?= old("weight_3", number_format(esc($production->weight_3), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 4;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_4" id="weight_4" step="1" min="0" placeholder="0"
                                <?php if($production->weight_4): ?>
                                    value='<?= old("weight_4", number_format(esc($production->weight_4), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 5;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_5" id="weight_5" step="1" min="0" placeholder="0"
                                <?php if($production->weight_5): ?>
                                    value='<?= old("weight_5", number_format(esc($production->weight_5), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 6;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_6" id="weight_6" step="1" min="0" placeholder="0"
                                <?php if($production->weight_6): ?>
                                    value='<?= old("weight_6", number_format(esc($production->weight_6), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 7;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_7" id="weight_7" step="1" min="0" placeholder="0"
                                <?php if($production->weight_7): ?>
                                    value='<?= old("weight_7", number_format(esc($production->weight_7), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 8;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_8" id="weight_8" step="1" min="0" placeholder="0"
                                <?php if($production->weight_8): ?>
                                    value='<?= old("weight_8", number_format(esc($production->weight_8), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 9;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_9" id="weight_9" step="1" min="0" placeholder="0"
                                <?php if($production->weight_9): ?>
                                    value='<?= old("weight_9", number_format(esc($production->weight_9), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 10;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_10" id="weight_10" step="1" min="0" placeholder="0"
                                <?php if($production->weight_10): ?>
                                    value='<?= old("weight_10", number_format(esc($production->weight_10), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>
                        <div style="grid-row:4; grid-column: 11;" class="weight-cell">
                            <input class="grid-cell s3 disableifapproved" type="number" name="weight_end" id="weight_end" step="1" min="0" placeholder="0"
                                <?php if($production->weight_end): ?>
                                    value='<?= old("weight_end", number_format(esc($production->weight_end), 0,decimal_separator: ".",thousands_separator: "")) ?>'
                                <?php endif; ?>
                            >
                        </div>

                    </div>
                </div>



                <div style="grid-column: 1; grid-row:5;">
                    <p class="s3" style="padding-left: 24pt;text-indent: 0pt;text-align: left;margin-top:15px;">Grind Size Consistency (If applicable)</p>
                </div>

                <div style="grid-column: 2; grid-row:5;">
                    <div style="display: grid; grid-template-columns:repeat(2,auto);">
                        <label class="s3" for="grind_size_espresso">Espresso</label>
                        <label class="s3" for="grind_size_filter">Filter</label>

                        <input class="disableifapproved" id="grind_size_espresso" type="radio" name="grind_size" style="vertical-align: middle;" <?= $production->grind_size == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('grind_size', 1) ?>>
                        <input class="disableifapproved" id="grind_size_filter" type="radio" name="grind_size" style="vertical-align: middle;" <?= $production->grind_size == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('grind_size', 0) ?>>
                    </div>
                </div>

            </div>

            <p class="s4" style="padding-top: 9pt;padding-bottom: 2pt;padding-left: 36pt;text-indent: -22pt;text-align: left;">6. Final Approval &amp; Actions Taken</p>
            <div class="final-approval">
                <!-- 5 columns -->
                <div style="grid-column:1 / SPAN 5; grid-row:1;">
                    <p class="s3 grid-cell" for="packaging_qc_by">Final Comments</p>
                </div>
                <div style="grid-column:1 / SPAN 5; grid-row:2 / SPAN 2; ">
                    <textarea class="grid-cell disableifapproved" name="final_comments" id="final_comments" rows="2">
                        <?= old("final_comments", esc($production->final_comments)) ?>
                    </textarea>
                </div>

                <div style="grid-column:1 / SPAN 2; grid-row:4;">
                    <p class="s15 grid-cell-center">Time Completed:</p>
                </div>
                <div style="grid-column:1 / SPAN 2; grid-row:5;">
                    <input class="grid-cell disableifapproved" type="time" name="time_completed" id="time_completed" value="<?= old("time_completed", esc($production->time_completed)) ?>">
                </div>

                <div style="grid-column: 3 / SPAN 2; grid-row: 4; place-self: center;">
                    <p class="s15">Operator Approval</p>
                </div>
                <div style="grid-column: 3 /SPAN 2; grid-row: 5; place-self: center;">
                    <?= $signatures['operator_approval'] ?>
                </div>

                <div style="grid-column: 5 / SPAN 2; grid-row: 4; place-self: center;">
                    <p class="s15">Team Leader QC Approval</p>
                </div>
                <div style="grid-column: 5 /SPAN 2; grid-row: 5; place-self: center;">
                    <?= $signatures['teamleader_approval'] ?>
                </div>

            </div>
            <button id="submit_btn" class="button grid-cell" type="submit">Save</button>
            <a id="cancel_btn" href="<?= url_to('Production::index') ?>" class="button grid-cell" style="background-color: darkred;">Cancel</a>
        </div>
    </div>
</main>
