<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Processes<?= $this->endSection() ?>
<?= $this->section("content") ?>

<?= view(
	"layouts/bcr-nav",
	[
		"title" => "Processes",
		"controller" => "Processes",
		"links" => [
			"New" =>  ["url" => url_to("Processes::new"), "auth_check" => true]
		]
	]
) ?>

<div class="index-div">
	<table>
		<tr>
			<th></th>
			<th>ID</th>
			<th>Process</th>
			<th>Last Updated</th>
			<th>Updated By</th>

			<?php
			foreach ($processes as $process) : ?>
		<tr>
			<td>
				<a href="<?= site_url('/processes/' . $process->ProcessID) ?>">
					<button>View</button>
				</a>
			</td>
			<td>
				<?= $process->ProcessID ?>
			</td>
			<td>
				<?= esc($process->Process) ?>
			</td>
			<td>
				<?= $process->lastupdated ?>
			</td>
			<td>
				<?= esc($process->username) ?>
			</td>
		</tr>
	<?php
			endforeach; ?>

	</table>

</div>
<?= $this->endSection() ?>