<?= $this->extend("layouts/default") ?>

<?= $this->section("title") ?>Input<?= $this->endSection() ?>


<?= $this->section("content") ?>
<style>
	:root {
		--background: --background-body;
	}
</style>

<?= view(
	"layouts/bcr-nav",
	[
		"title" => "Input",
		"controller" => "Inputs",
		"links" => [
			"Inputs' List" =>  ["url" => url_to("Inputs::index"), "auth_check" => true]
		]
	]
) ?>


<div class="round-border">

	<h1>Input</h1>

	<table>
		<tr>
			<td><b>ID</b></td>
			<td><?= $input->InputID ?></td>
		</tr>
		<tr>
			<td><b>Input Type</b></td>
			<td><?= $input->InputType ?></td>
		</tr>
		<tr>
			<td><b>Input Name</b></td>
			<td><?= $input->InputName ?></td>
		</tr>
		<tr>
			<td><b>Input Code</b></td>
			<td><?= $input->InputCode ?></td>
		</tr>
		<tr>
			<td><b>Supplier</b></td>
			<td><?= $input->Supplier ?></td>
		</tr>
		<tr>
			<td><b>Country</b></td>
			<td><?= $input->Country ?></td>
		</tr>
		<tr>
			<td><b>Process</b></td>
			<td><?= $input->Process ?></td>
		</tr>
		<tr>
			<td><b>Certification</b></td>
			<td><?= $input->Certification ?></td>
		</tr>
		<tr>
			<td><b>Box Price (Packaging)</b></td>
			<td><?= $input->CostPack ?></td>
		</tr>
		<tr>
			<td><b>Price(Kg)</b></td>
			<td><?= $input->Cost ?></td>
		</tr>
		<tr>
			<td><b>Price Valid From</b></td>
			<td><?= $input->ValidFromDate ?></td>
		</tr>
		<tr>
			<td><b>Conversion Factor</b></td>
			<td><?= $input->ConversionFactor ?></td>
		</tr>
		<tr>
			<td><b>Production Wastage (%)</b></td>
			<td><?= $input->WastePercent ?></td>
		</tr>
		<tr>
			<td><b>Cost Updated</b></td>
			<td><?= $input->CostUpdated ?></td>
		</tr>
		<tr>
			<td><b>In Stock(Kg)</b></td>
			<td><?= $input->StockQty ?></td>
		</tr>
		<tr>
			<td><b>Left on Contract(Kg)</b></td>
			<td><?= $input->LeftOnContract ?></td>
		</tr>
		<tr>
			<td><b>Record updated</b></td>
			<td><?= $input->lastupdated ?></td>
		</tr>
		<tr>
			<td><b>Notes</b></td>
			<td><?= $input->Notes ?></td>
		</tr>
	</table>

	<a href="<?= base_url("InputCosts/$input->InputID") ?>" class="button">Pricing Table</a>

	<?= view("layouts/deletebtnrecipes", ["controller" => "Inputs", 'id' => (string)$input->InputID, "urltodelete" => "Inputs::confirmDelete", "urltoedit" => "Inputs::edit"]) ?>

</div>

<?= $this->include("layouts/usedbyrecipes") ?>


<?= $this->endSection() ?>