<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Inputs<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<link rel="stylesheet" href="<?= base_url('/js/tabulator-master/dist/css/tabulator_simple.css') ?>" />

<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/luxon.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/tabulator-master/dist/js/tabulator.min.js') ?>"> </script>
<?= $this->endSection() ?>

<?= $this->section("content") ?>


<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Inputs",
        "controller" => "Inputs",
        "links" => [
            "New" =>  ["url" => url_to("Inputs::new"), "auth_check" => true]
        ]
    ]
) ?>


<?= view("layouts/tabulatorgrid") ?>


<script type='text/javascript'>

	new Tabulator('#wrapper',{

		data: [
			<?php foreach ($inputs as $input): ?>
			<?="{" ?>
			<?="InputID:$input->InputID," ?>
			<?="InputType:'".addslashes($input->InputType)."'," ?>
			<?="InputName:'".addslashes($input->InputName)."'," ?>
			<?="InputCode:'".addslashes($input->InputCode)."'," ?>
			<?="Cost:$input->Cost," ?>
			<?="ValidFromDate:'$input->ValidFromDate'," ?>
			<?="NextCost:$input->NextCost," ?>
			<?="NextValidFromDate:'$input->NextValidFromDate'," ?>
			<?="CostPack:$input->CostPack," ?>
			<?="ConversionFactor:$input->ConversionFactor," ?>
			<?="StockQty:$input->StockQty," ?>
			<?="LeftOnContract:$input->LeftOnContract," ?>
			<?="Supplier:'".addslashes($input->Supplier)."'," ?>
			<?="Country:'".addslashes($input->Country)."'," ?>
			<?="Certification:'".addslashes($input->Certification)."'," ?>
			<?="Process:'".addslashes($input->Process)."'," ?>
			<?="lastupdated:'$input->lastupdated'," ?>
			<?="updatedby:'".addslashes($input->username)."'," ?>
			<?="}," ?>
			<?= chr(13).chr(10) ?>
			<?php endforeach; ?>
		],
		layout:"fitDataStretch",
		pagination: false,
		//height:"100%",
		//paginationSize: 25,
		tooltips: true,
		//maxHeight:"100vh",
		//editTriggerEvent:"click",

		//layout:"fitDataStretch",
		// responsiveLayout:"hide",
		//pagination: true, //"local",
		//paginationSize: 25,
		//tooltips: true,
		columns: [{
				title: "InputID",
				field: "InputID",
				sorter: "number",
				width: 150,
				visible: false,
			}, {
				title: "Input Type",
				field: "InputType",
				sorter: "string",
				hozAlign: "left",
				width: 120,
				headerFilter:"list",
				headerFilterParams:{valuesLookup:true, clearable:true},
				responsive:0,
			},
			{
				title: "Input Name",
				field: "InputName",
				sorter: "string",
				hozAlign: "left",
				width: 200,
				headerFilter:"input",
				responsive:0,
				//headerFilterParams:{valuesLookup:true, clearable:true},
			}, {
				title: "Input Code",
				field: "InputCode",
				sorter: "string",
				hozAlign: "left",
				width: 120,
				headerFilter:"input",
				responsive:0,
				//headerFilterParams:{valuesLookup:true, clearable:true},
			}, {
				title: "Cost",
				field: "Cost",
				sorter: "number",
				hozAlign: "right",
				width: 80,
				responsive:0,
			},{
				title: "Valid From",
				field: "ValidFromDate",
				hozAlign: "left",
				responsive: 4,
				width: 170,
				formatter: "datetime",
				formatterParams: {
					inputFormat: "yyyy-LL-dd",
					outputFormat: "dd/MM/yyyy",
					invalidPlaceholder: "(invalid date)",
					timezone: "system",
				},
				sorter: "datetime",
				sorterParams: {
					format: "yyyy-MM-dd",
					alignEmptyValues: "top",
				}
			},{
				title: "Next Cost",
				field: "NextCost",
				sorter: "number",
				hozAlign: "right",
				width: 80,
				responsive:0,
			}, {
				title: "Next Valid From",
				field: "NextValidFromDate",
				hozAlign: "left",
				width: 170,
				formatter: "datetime",
				formatterParams: {
					inputFormat: "yyyy-LL-dd",
					outputFormat: "dd/MM/yyyy",
					invalidPlaceholder: "(invalid date)",
					timezone: "system",
				},
				sorter: "datetime",
				sorterParams: {
					format: "yyyy-MM-dd",
					alignEmptyValues: "top",
				}
			}, {
				title: "Box Cost<br>(Packaging)",
				field: "CostPack",
				sorter: "number",
				hozAlign: "right",
				width: 130,
				responsive:2,
			}, {
				title: "Stock Qty",
				field: "StockQty",
				sorter: "number",
				hozAlign: "right",
				width: 100,
				responsive:2,
			}, {
				title: "Conversion<br/>Factor",
				field: "ConversionFactor",
				sorter: "number",
				hozAlign: "right",
				width: 100,
				responsive:2,
				// }, {
				//     title: "Production<br/>Waste(%)",
				//     field: "WastePercent",
				//     sorter: "number",
				//     hozAlign: "right",
				//     width: 100,
				//     responsive:2,
			}, {
				title: "Left On<br>Contract",
				field: "LeftOnContract",
				sorter: "number",
				hozAlign: "right",
				width: 100,
				responsive:2,
			}, {
				title: "Supplier",
				field: "Supplier",
				sorter: "string",
				hozAlign: "left",
				width: 120,
				headerFilter:"list",
				headerFilterParams:{valuesLookup:true, clearable:true},
				responsive:3,
			}, {
				title: "Country",
				field: "Country",
				sorter: "string",
				hozAlign: "left",
				width: 120,
				headerFilter:"list",
				headerFilterParams:{valuesLookup:true, clearable:true},
				responsive:3,
			}, {
				title: "Certification",
				field: "Certification",
				sorter: "string",
				hozAlign: "left",
				width: 120,
				headerFilter:"list",
				headerFilterParams:{valuesLookup:true, clearable:true},
				responsive:3,
			}, {
				title: "Process",
				field: "Process",
				sorter: "string",
				hozAlign: "left",
				width: 120,
				headerFilter:"list",
				headerFilterParams:{valuesLookup:true, clearable:true},
				responsive:3,
			}, {
				title: "Record Updated",
				field: "lastupdated",
				sorter: "datetime",
				hozAlign: "left",
				width: "fit-content",
				responsive:4,
				formatter:"datetime", formatterParams:{
					inputFormat:"yyyy-LL-dd TT",
					outputFormat:"dd/MM/yyyy TT",
					invalidPlaceholder:"(invalid date)",
					timezone:"system",
				}
			}, {
				title: "Updated By",
				field: "updatedby",
				sorter: "string",
				hozAlign: "left",
				width: 120,
				headerFilter:"list",
				headerFilterParams:{valuesLookup:true, clearable:true},
				responsive:3,
			},
		],
	}).on('rowClick', function(e, row) {
		window.location = '<?= base_url("inputs")."/"?>' + row.getCell('InputID').getValue();
	});
</script>


<?= $this->endSection() ?>

<?= $this->section("javascript") ?>
<?= $this->endSection() ?>

