<div class="round-border">
    <main style="padding:1em; display:grid; gap:1rem; grid-template-columns:repeat(3,1fr);">
        <div>
            <label for="InputTypeID">Input Type</label>
            <select name="InputTypeID" id="InputTypeID">
                <?php foreach ($inputtypes as $inputtype): ?>
                    <option value="<?= $inputtype->InputTypeID ?>"
                        <?= $inputtype->InputTypeID == $input->InputTypeID ? 'selected' : '';  ?>>
                        <?= $inputtype->InputType ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="InputName">Input Name</label>
            <input type="text" id="InputName" name="InputName"
                value="<?= old("InputName", esc($input->InputName)) ?>" spellcheck="true">
        </div>
        <div>
            <label for="InputCode">Input Code</label>
            <input type="text" id="InputCode" name="InputCode"
                value="<?= old("InputCode", esc($input->InputCode)) ?>" spellcheck="true">
        </div>
        <div>
            <label for="SupplierID">Supplier</label>
            <select name="SupplierID" id="SupplierID">
                <?php foreach ($suppliers as $supplier): ?>
                    <option value="<?= $supplier->SupplierID ?>"
                        <?= $supplier->SupplierID == $input->SupplierID ? 'selected' : '';  ?>>
                        <?= $supplier->Supplier ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="CountryID">Country</label>
            <select name="CountryID" id="CountryID">
                <?php foreach ($countries as $country): ?>
                    <option value="<?= $country->CountryID ?>"
                        <?= $country->CountryID == $input->CountryID ? 'selected' : '';  ?>>
                        <?= $country->Country ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="ProcessID">Process</label>
            <select name="ProcessID" id="ProcessID">
                <?php foreach ($processes as $process): ?>
                    <option value="<?= $process->ProcessID ?>"
                        <?= $process->ProcessID == $input->ProcessID ? 'selected' : '';  ?>>
                        <?= $process->Process ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="CertificationID">Certification</label>
            <select name="CertificationID" id="CertificationID">
                <?php foreach ($certifications as $certification): ?>
                    <option value="<?= $certification->CertificationID ?>"
                        <?= $certification->CertificationID == $input->CertificationID ? 'selected' : '';  ?>>
                        <?= $certification->Certification ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div>
            <label for="CostPack">Box Price (Packaging)</label>
            <input type="number" id="CostPack" name="CostPack" step="0.01"
                value="<?= old("CostPack", esc($input->CostPack)) ?>">
        </div>
<!--         <div>
            <label for="Cost">Price (Kg or Ea)</label>
            <input type="number" id="Cost" name="Cost" step="0.01"
                value="<?= old("Cost", esc($input->Cost)) ?>">
        </div>
 -->        <div>
            <label for="ConversionFactor">Conversion Factor(e.g. 1000 for Kg to g)</label>
            <input type="number" id="ConversionFactor" name="ConversionFactor" step="0.01"
                value="<?= old("ConversionFactor", esc($input->ConversionFactor)) ?>">
        </div>
        <div>
            <label for="WastePercent" title="Used to calculate demand for Non Coffee inputs.Coffee Waste % is set at the Recipe level.">Production Wastage(%) - (Does NOT apply to coffee)</label>
            <input type="number" id="WastePercent" name="WastePercent" step="0.01"
                value="<?= old("WastePercent", esc($input->WastePercent)) ?>">
        </div>
        <div>
            <label for="StockQty">In Stock (Kg)</label>
            <input type="number" id="StockQty" name="StockQty" step="0.01"
                value="<?= old("StockQty", esc($input->StockQty)) ?>">
        </div>
        <div>
            <label for="LeftOnContract">Coffee Left on Contract (Kg)</label>
            <input type="number" id="LeftOnContract" name="LeftOnContract" step="0.01"
                value="<?= old("LeftOnContract", esc($input->LeftOnContract)) ?>">
        </div>
        <div style="grid-column: 1 / SPAN 3;">

            <label for="Notes">Notes</label>
            <textarea name="Notes" id="Notes" rows="10" value="<?= old("Notes", esc($input->Notes)) ?>"></textarea>
        </div>

        <div style="grid-column: 1 / SPAN 3; text-align: center;">
            <button class="button" type="submit">Save</button>

            <a class="button" href="<?= previous_url() ?>" default>Cancel</a>
        </div>
    </main>
</div>