<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Input Types<?= $this->endSection() ?>
<?= $this->section("content") ?>

<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Input Types",
        "controller" => "Inputtypes",
        "links" => [
            "New" =>  ["url" => url_to("Inputtypes::new"), "auth_check" => true]
        ]
    ]
) ?>

<table>
    <tr>
        <th></th>
        <th>ID</th>
        <th>Input Type</th>
        <th>Display Order</th>
        <th>Is Coffee</th>
        <th>Last Updated</th>
        <th>Updated By</th>

        <?php foreach ($inputtypes as $inputtype): ?>
    <tr>
        <td>
            <a href="<?= site_url('/inputtypes/' . $inputtype->InputTypeID) ?>">
                <button>View</button>
            </a>
        </td>
        <td>
            <?= $inputtype->InputTypeID ?>
        </td>
        <td>
            <?= esc($inputtype->InputType) ?>
        </td>
        <td>
            <?= $inputtype->DisplayOrder ?>
        </td>
        <td>
            <?= $inputtype->IsCoffee == 1 ? 'Y' : 'N' ?>
        </td>
        <td>
            <?= $inputtype->lastupdated ?>
        </td>
        <td>
            <?= esc($inputtype->username) ?>
        </td>
    </tr>
<?php endforeach; ?>


</table>

</div>
<?= $this->endSection() ?>