<?= $this->extend("layouts/clean") ?>
<?= $this->section("title") ?>Inputs and Valid From Dates<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<link rel="stylesheet" href="<?= base_url('/js/tabulator-master/dist/css/tabulator_simple.css') ?>" />

<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/luxon.min.js') ?>"> </script>
<script type='text/javascript' src="<?=base_url('/js/tabulator-master/dist/js/tabulator.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js');?>"></script>
<link rel="stylesheet" href="<?=base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">
<script type='text/javascript' src="<?=base_url('/js/htmx/htmx.min.js');?>"></script>
<?= $this->endSection() ?>

<?= $this->section("content") ?>

<input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">
<div id="res"></div>

<?= view("layouts/tabulatorgrid", ["tabulatortitle" => "Valid From Dates $recipe->RecipeName", "urltonew" => "", "controller" => "InputCosts"]) ?>

<script type='text/javascript'>

//inputcosts.InputID, inputs.InputName, inputcosts.Cost, inputcosts.ValidFromDate
    var table = new Tabulator('#wrapper',{
        rowFormatter: function(row) {
            //row - row component
            var validfrom = '<?= $validfromdate ?>';
            var nextvalidfrom = '<?= $nextvalidfromdate ?>';
            var data = row.getData();
            var style = row.getElement().style;
            if (data.ValidFromDate == validfrom || data.ValidFromDate == nextvalidfrom) {
                row.getElement().style.backgroundColor = "#dd810f";
                row.getElement().style.color = "#ffffff";
            }
            //row.getElement().style.Selection = data.HeaderColour; //  "#76EE00";
            //row.getElement().style.color = "#000000"; //  "#76EE00";
            //}
        },

        data: [
            <?php foreach ($inputcosts as $inputcost): ?>
            <?="{" ?>
            <?="InputID:$inputcost->InputID," ?>
            <?="InputName:'".addslashes($inputcost->InputName)."'," ?>
            <?="Cost:$inputcost->Cost," ?>
            <?="ValidFromDate:'$inputcost->ValidFromDate'," ?>
            <?="}," ?>
            <?= chr(13).chr(10) ?>
            <?php endforeach; ?>
        ],
        layout:"fitDataStretch",
        pagination: false,
        tooltips: true,
        columns: [{
                title: "InputID",
                field: "InputID",
                sorter: "number",
                //width: 150,
                visible: false,
            }, {
                title: "Input",
                field: "InputName",
                sorter: "string",
                hozAlign: "left",
                //width: "fit-content",
                headerFilter:"list",
                headerFilterParams:{valuesLookup:true, clearable:true},
                responsive:3,
            },{
                title: "Price/Kg",
                field: "Cost",
                sorter: "number",
                hozAlign: "right",
                //width: "fit-content",
                responsive:0,
                formatter: "money",
                formatterParams:{
                    decimal:".",
                    thousand:"",
                    symbol:"£",
                    symbolAfter:"",
                    negativeSign:true,
                    precision:2,
                }
            }, {
                title: "Valid From",
                field: "ValidFromDate",
                sorter: "datetime",
                hozAlign: "left",
                //width: "fit-content",
                formatter: "datetime",
                formatterParams: {
                    inputFormat: "yyyy-LL-dd TT",
                    outputFormat: "dd/MM/yyyy",
                    invalidPlaceholder: "(invalid date)",
                    timezone: "system",
                },
                sorter: "datetime",
                sorterParams: {
                    format: "yyyy-MM-dd HH:mm:ss",
                    alignEmptyValues: "top",
                }
            },
        ],
    });
</script>


<?= $this->endSection() ?>

<?= $this->section("javascript") ?>
<?= $this->endSection() ?>

