<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>RoastPRO<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('css/home.css') . '?' . rand() ?>" />
<script src="<?= base_url('js/jquery/jquery-3.7.1.min.js') . '?' . rand() ?>"></script>
<script src="<?= base_url('js/jquery-connections/jquery.connections.js') . '?' . rand() ?>"></script>

<?= $this->endSection() ?>

<?= $this->section("content") ?>

<?= view("layouts/bcr-nav",
    [
        "title" => "Welcome",
        "links" => []
    ]
) ?>

<div>
    <div class="home-outer" style="display: grid; gap:1rem; grid-template-columns:1fr;">

        <div class="home-main" style="display: grid; gap:1rem; grid-template-columns:1fr;">

            <div class="home-level" style="display: grid; gap:1rem; grid-template-columns:repeat(7,auto);">
                <div class="bvr-blue-text" style="
                    font-weight:bold;
                    font-size:large;
                    text-align:left;
                    grid-column:1 / span 7;
                    align-items:left;
                    background-color: rgb(255  255 255 / 0.55);
                    ">
                    Production
                </div>

                <div style="grid-column:3; grid-row:2">
                    <?php if ((auth()->user()->can_access('Green Coffee Inspection'))): ?>
                        <a class="button production" href="<?= site_url('/greencoffees') ?>">
                            Green Coffee Inspection
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button production">
                            Green Coffee Inspection
                        </div>
                    <?php endif; ?>
                </div>

                <div style="grid-column:5; grid-row:2">
                    <?php if ((auth()->user()->can_access('Coffee Quality Control Checklist'))): ?>
                        <a class="button production" href="<?= site_url('/production') ?>">
                            Coffee Quality Control Checklist
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button production">
                            Coffee Quality Control Checklist
                        </div>
                    <?php endif; ?>
                </div>

            </div>

            <div class="home-level" style="display: grid; gap:1rem; grid-template-columns:repeat(6,auto);">
                <div class="bvr-blue-text" style="
                    font-weight:bold;
                    font-size:large;
                    text-align:left;
                    grid-column:1 / span 6;
                    align-items:left;
                    background-color: rgb(255  255 255 / 0.55);
                    ">
                    Price Lists
                </div>

                <div style="grid-column:3; grid-row:2">
                    <?php if ((auth()->user()->can_access('Internal Price List'))): ?>
                        <a class="button demand" href="<?= site_url('/pricelist/0') ?>">
                            Internal Price List
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button demand">
                            Internal Price List
                        </div>
                    <?php endif; ?>
                </div>

                <div style="grid-column: 4; grid-row: 2;">
                    <?php if ((auth()->user()->can_access('Customer Price List'))): ?>
                        <select name="PricelistCustomer" id="PricelistCustomer" class="PricelistCustomer" style="background-color: #213242; color: white;" onchange="showCustomerPricelist();">
                            <option value="-1">Customer Price List</option>
                            <option value="0">Show All</option>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?= $category->CategoryID ?>"><?= $category->Category ?></option>
                        <?php endforeach; ?>
                        </select>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button demand">
                            Customer Price List
                        </div>
                    <?php endif; ?>
                </div>




            </div>

            <div class="home-level" style="display: grid; gap:1rem; grid-template-columns:repeat(<?= count($inputtypes) ?>,auto);">
                <div class="bvr-blue-text" style="
                    font-weight:bold;
                    font-size:large;
                    text-align:left;
                    grid-column:1 / span <?= count($inputtypes) ?>;
                    align-items:left;
                    background-color: rgb(255  255 255 / 0.55);
                    /* border: 5px solid #dd810f;
                    border-radius: 5px; */
                    padding: 5px;
                    ">

                    Annual Demands
                </div>

                <?php foreach ($inputtypes as $inputtype): ?>
                    <div style="grid-row:2">
                        <?php if ((auth()->user()->can_access(ucwords(strtolower($inputtype->InputType))))): ?>
                            <a class="button demand" href="<?= site_url('/coffeedemand') . '/' . $inputtype->InputTypeID ?>">
                                <?= ucwords(strtolower($inputtype->InputType)) ?>
                            </a>
                        <?php else: ?>
                            <div style="background-color: darkgrey;" class="button demand">
                                <?= ucwords(strtolower($inputtype->InputType)) ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="home-level" style="display: grid; gap:1rem; grid-template-columns:repeat(5,auto);">
                <div style="grid-column: 3; grid-row:1;">
                    <?php if ((auth()->user()->can_access('Recipes'))): ?>
                        <a class="button recipes" style="background-color: #e04d2b; border-color: #dd810f;;border-width: 5px;border-spacing: 10px;border-style: solid;" href="<?= site_url('/recipes') ?>">
                            Recipes
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;border-color: #dd810f;border-width: 5px;border-spacing: 10px;border-style: solid;" class="button recipes">
                            Recipes
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div id="inputs-level" class="home-level" style="display: grid; gap:1rem; grid-template-columns:repeat(5,1fr);">
                <div style="grid-column: 1; grid-row:1;">
                    <?php if ((auth()->user()->can_access('Categories'))): ?>
                        <a class="button categories" href="<?= site_url('/categories') ?>">
                            Categories
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button categories">
                            Categories
                        </div>
                    <?php endif; ?>
                </div>
                <div style="grid-column: 2; grid-row:2;">
                    <?php if ((auth()->user()->can_access('Roast Levels'))): ?>
                        <a class="button categories" href="<?= site_url('/roastlevels') ?>">
                            Roast Levels
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button categories">
                            Roast Levels
                        </div>
                    <?php endif; ?>
                </div>
                <div style="grid-column: 3; grid-row:3;">
                    <?php if ((auth()->user()->can_access('Inputs'))): ?>
                        <a class="button inputs" href="<?= site_url('/inputs') ?>">
                            Inputs
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button inputs">
                            Inputs
                        </div>
                    <?php endif; ?>
                </div>
                <div style="grid-column: 4; grid-row:2;">
                    <?php if ((auth()->user()->can_access('Roast Colours'))): ?>
                        <a class="button roastcolours" href="<?= site_url('/RoastColours') ?>">
                            Agtron Numbers
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button roastcolours">
                            Agtron Numbers
                        </div>
                    <?php endif; ?>
                </div>
                <div style="grid-column: 5; grid-row:1;">
                    <?php if ((auth()->user()->can_access('Templates'))): ?>
                        <a class="button categories" href="<?= site_url('/templates') ?>">
                            Templates
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button categories">
                            Templates
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div id="component-level" class="home-level" style="display: grid; row-gap:1rem; grid-template-columns:repeat(5,1fr);">
                <div style="grid-column: 1; grid-row:1;">
                    <?php if ((auth()->user()->can_access('Certifications'))): ?>
                        <a class="button component" href="<?= site_url('/certifications') ?>">
                            Certifications
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button component">
                            Certifications
                        </div>
                    <?php endif; ?>
                </div>
                <div style="grid-column: 5; grid-row:1;">
                    <?php if ((auth()->user()->can_access('Input Types'))): ?>
                        <a class="button component" href="<?= site_url('/inputtypes') ?>">
                            Input Types
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button component">
                            Input Types
                        </div>
                    <?php endif; ?>
                </div>

                <div style="grid-column: 2; grid-row:2;">
                    <?php if ((auth()->user()->can_access('Countries'))): ?>
                        <a class="button component" href="<?= site_url('/countries') ?>">
                            Countries
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button component">
                            Countries
                        </div>
                    <?php endif; ?>
                </div>
                <div style="grid-column: 4; grid-row:2;">
                    <?php if ((auth()->user()->can_access('Processes'))): ?>
                        <a class="button component" href="<?= site_url('/processes') ?>">
                            Processes
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button component">
                            Processes
                        </div>
                    <?php endif; ?>
                </div>

                <div style="grid-column: 3; grid-row:3;">
                    <?php if ((auth()->user()->can_access('Suppliers'))): ?>
                        <a class="button component" href="<?= site_url('/suppliers') ?>">
                            Suppliers
                        </a>
                    <?php else: ?>
                        <div style="background-color: darkgrey;" class="button component">
                            Suppliers
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function showCustomerPricelist()
    {
        var id = $('#PricelistCustomer').val();
        //console.log(id);
        if(parseInt(id) >= 0){
            var url = "<?= site_url('/PricelistCustomer/') ?>" + id;
            //console.log(url);
            $('#PricelistCustomer').val("-1");
            window.open(url, '_blank').focus();
        }else{
            $('#PricelistCustomer').val("-1");
        }
    }

    function drawConnections() {
        $().connections({
            from: 'a.inputs',
            to: 'a.component'
        });
        $().connections({
            from: 'a.recipes',
            to: 'a.inputs'
        });
        $().connections({
            from: 'a.recipes',
            to: 'a.categories'
        });
        $().connections({
            from: 'a.demand',
            to: 'a.recipes',
            css: {
                border: '5px solid #dd810f',
            }
        });
        $().connections({
            from: 'select.PricelistCustomer',
            to: 'a.recipes',
            css: {
                border: '5px solid #dd810f',
            }
        });
        $().connections({
            from: 'a.recipes',
            to: 'a.roastcolours'
        });
        $().connections({
            from: 'a.recipes',
            to: 'a.production',
            css: {
                border: '5px solid #dd810f',
            }
        });
    }

    function setBcrTitle() {
        var dd = new Date();
        var hh = dd.getHours();
        var who = "<?= esc(auth()->user()->username) ?>";
        if(hh > 11){
            $("#bcr_title").html("Good afternoon " + who);
        }else{
            $("#bcr_title").html("Good morning " + who);
        }

    }

    jQuery(document).ready(function() {
        setBcrTitle();
        drawConnections();
    });

    $(window).on("resize", function() {
        $('a.component').connections('update');
        $('a.inputs').connections('update');
        $('a.categories').connections('update');
        $('a.recipes').connections('update');
        $('a.customerpricelist').connections('update');

    });
</script>

<?= $this->endSection() ?>
