<?=$this->extend("layouts/default");?>
<?=$this->section("title");?>Green Coffee Inspection<?=$this->endSection();?>

<?=$this->section("header");?>
<link rel="stylesheet" href="<?=base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css');?>" />
<link rel="stylesheet" href="<?=base_url('/js/tabulator-master/dist/css/tabulator_simple.css');?>" />

<script type='text/javascript' src="<?=base_url('/js/jquery/jquery-3.7.1.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/luxon.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/tabulator-master/dist/js/tabulator.min.js');?>"></script>
<script type='text/javascript' src="<?=base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js');?>"></script>
<link rel="stylesheet" href="<?=base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">
<script type='text/javascript' src="<?=base_url('/js/htmx/htmx.min.js');?>"></script>
<?=$this->endSection();?>

<?=$this->section("content");?>

<input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

<div id="res"></div>

<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Green Coffee Inspection",
        "controller" => "GreenCoffees",
        "links" => [
            "New" =>  ["url" => url_to("GreenCoffees::new"), "auth_check" => true]
        ]
    ]
) ?>

<?=view("layouts/tabulatorgrid");?>

<script type='text/javascript'>
    var rowMenu = [{
        label:"<i class='fas fa-trash'></i> Delete Row",
        action:function(e, row){
            e.preventDefault();
            var coffee_name = row.getCell('coffee_name').getValue();
            var greencoffeeid = row.getCell('GreenCoffeeID').getValue();
            DayPilot.Modal.confirm("DELETE Green Coffee Inspection for Coffee: "+coffee_name+"?",
            { theme: "modal_rounded" }).then(function(args) {
//            console.log(args.result);
              //var greencoffeeid = row.getCell('GreenCoffeeID').getValue();
            if(args.result){
                let csrfField = document.getElementById('csrfcode');
                let htmxpath = "<?= base_url("greencoffees/delete")?>";
                let csrfname = csrfField.name;
                let csrfval = csrfField.value;
                let success = 0;
                let vals = {};
                vals['GreenCoffeeID'] = greencoffeeid;
                vals[csrfname] = csrfval;
                htmx.ajax('POST',
                    htmxpath,
                    {
                        target: "#res",
                        swap: 'none',
                        handler: (_, response) => {
                            //console.log(response.xhr.response);
                            res = JSON.parse(response.xhr.response);
                            success = res.success;
                            //console.log(success);
                            //console.log(res.token);
                            $('#csrfcode').val(res.token);
                            if(success == 1){
                                //console.log(success);
                                row.delete();
                            }else{
                                DayPilot.Modal.alert("Something went wrong. I can't delete this Green Coffee Inspection",
                                { theme: "modal_rounded" });
                            }
                        },
                        values: vals
                    }
                );
            }
        });
        }
    }];

//event.detail.headers['X-CSRFToken'] = '{{ csrf_token }}';
    new Tabulator('#wrapper', {

        data: [
            <?php foreach ($greencoffees as $greencoffee): ?>
                <?="{";?>
                <?="GreenCoffeeID:$greencoffee->GreenCoffeeID,";?>
                <?="coffee_name:'" . addslashes($greencoffee->coffee_name) . "',";?>
                <?="sap_po_no:'" . addslashes($greencoffee->sap_po_no) . "',";?>
                <?="delivery_note_no:'" . addslashes($greencoffee->delivery_note_no) . "',";?>
                <?="delivery_date:'$greencoffee->delivery_date',";?>
                <?="approved_by:'" . addslashes($greencoffee->approved_by) . "',";?>
                <?="date_approved:'$greencoffee->date_approved',";?>
                <?="lastupdated:'$greencoffee->lastupdated',";?>
                <?="updatedby:'" . addslashes($greencoffee->username) . "',";?>
                <?="},";?>
                <?=chr(13) . chr(10);?>
            <?php endforeach;?>
        ],
        layout: "fitDataStretch",
        pagination: false,
        tooltips: true,
        <?php   
            if (auth()->user()->inGroup('admin')){
                echo "rowContextMenu: rowMenu,";
            }
        ?>
        columns: [{
                title: "GreenCoffeeID",
                field: "GreenCoffeeID",
                sorter: "number",
                height: "100%",
                width: 150,
                visible: false,
            }, {
                title: "Coffee",
                field: "coffee_name",
                sorter: "string",
                hozAlign: "left",
                width: 200,
                headerFilter: "list",
                headerFilterParams: {
                    valuesLookup: true,
                    clearable: true
                },
                responsive: 0,
            },
            {
                title: "SAP PO No",
                field: "sap_po_no",
                sorter: "string",
                hozAlign: "left",
                width: 200,
                headerFilter: "input",
                responsive: 0,
            },{
                title: "Delivery Note",
                field: "delivery_note_no",
                sorter: "string",
                hozAlign: "left",
                width: 200,
                headerFilter: "input",
                responsive: 0,
            },{
                title: "Delivery Date",
                field: "delivery_date",
                hozAlign: "left",
                responsive: 4,
                formatter: "datetime",
                formatterParams: {
                    inputFormat: "yyyy-LL-dd TT",
                    outputFormat: "dd/MM/yyyy",
                    invalidPlaceholder: "(invalid date)",
                    timezone: "system",
                },
                sorter: "datetime",
                sorterParams: {
                    format: "yyyy-MM-dd HH:mm:ss",
                    alignEmptyValues: "top",
                }
            }, {
                title: "Approved by",
                field: "approved_by",
                sorter: "string",
                hozAlign: "left",
                headerFilter: "input",
                responsive: 0,
                headerFilter: "list",
                headerFilterParams: {
                    valuesLookup: true,
                    clearable: true
                },
            },{
                title: "Date Approved",
                field: "date_approved",
                hozAlign: "left",
                responsive: 4,
                formatter: "datetime",
                formatterParams: {
                    inputFormat: "yyyy-LL-dd TT",
                    outputFormat: "dd/MM/yyyy TT",
                    invalidPlaceholder: "(invalid date)",
                    timezone: "system",
                },
                sorter: "datetime",
                sorterParams: {
                    format: "yyyy-MM-dd HH:mm:ss",
                    alignEmptyValues: "top",
                }
            },{
                title: "Record Updated",
                field: "lastupdated",
                hozAlign: "left",
                responsive: 4,
                formatter: "datetime",
                formatterParams: {
                    inputFormat: "yyyy-LL-dd TT",
                    outputFormat: "dd/MM/yyyy TT",
                    invalidPlaceholder: "(invalid date)",
                    timezone: "system",
                },
                sorter: "datetime",
                sorterParams: {
                    format: "yyyy-MM-dd HH:mm:ss",
                    alignEmptyValues: "top",
                }
            }, {
                title: "Updated By",
                field: "updatedby",
                sorter: "string",
                hozAlign: "left",
                headerFilter: "list",
                headerFilterParams: {
                    valuesLookup: true,
                    clearable: true
                },
                responsive: 3,
            },
        ],
    }).on('rowClick', function(e, row) {
        window.location = '<?=base_url("greencoffees") . "/";?>' + row.getCell('GreenCoffeeID').getValue() + '/edit';
    });


</script>


<?=$this->endSection();?>

<?=$this->section("javascript");?>
<?=$this->endSection();?>