<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="<?= base_url('/css/greencoffees.css') . '?' . rand() ?>" />
<script type="text/javascript" src="<?php echo base_url('js/jquery/jquery-3.7.1.min.js'); ?>"></script>
<script type="text/javascript" src="<?php echo base_url('js/jquery-ui-1.14.1/jquery-ui.min.js'); ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/html-duration-picker.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('js/htmx/htmx.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js'); ?>"></script>
<link rel="stylesheet" href="<?= base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">

<style>
    .scroll-btn {
        min-width: 0;
        background-color: unset;
        color: unset;
        border-radius: unset;
    }

	.inputchange {
		border-style: none;
	}
    input:disabled {
        color: #1E1E1E;
    }
input[disabled][type="radio"]:checked::before {
    content: "\25C9";
    position: relative;
    z-index: 100;
    top: -3px;
    left: .5px;
}

input[type="radio"]:checked + .option-label, input[type="checkbox"]:checked + .option-label {
  font-weight: 600;
}

input[disabled][type="checkbox"]:checked::before {
    content: "\2611";
    position: relative;
    background: white;
    font-size: 17px;
    top: -7px;
    left: .5px;
    font-weight: 600;
}

</style>

<input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

<main>
    <div id="res"></div>
    <div class="outer">
        <div style="grid-column: 1;  grid-row: 1; ">
            <div style="display: grid; grid-template-columns: 80% 20%; padding: 0; margin:0; ">
                <p class="s1" style="padding-top: 11pt;padding-left: 10pt;text-indent: 0pt;text-align: left;">Green Coffee Inspection</p>
                <div>
                    <a class="/*button*/" href="<?= url_to('GreenCoffees::index') ?>"><img style="width: 15vw;" src="<?= base_url('/images/RoastPRO-02.jpg') ?>" alt=""></a>
                </div>
            </div>
            <div class="coffee-quality-control-checklist">
                <div style="grid-column:1 /SPAN 2;">
                    <p class="s2" style="padding-top: 2pt;padding-left: 5pt;text-indent: 0pt;text-align: left;">Coffee Name:
                        <select class="cell-required disableifapproved" name="coffee_name" id="coffee_name" required onchange="getGreenCoffees()">
                            <?php foreach ($coffees as $coffee): ?>
                                <option value="<?= $coffee->InputName ?>"
                                    <?= $coffee->InputName == $greencoffee->coffee_name ? 'selected' : '';  ?>>
                                    <?= $coffee->InputName ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </p>
                    <p class="s2" style="padding-top: 2pt;padding-left: 5pt;text-indent: 0pt;text-align: left;">
                        SAP PO No:
                        <input class="grid-cell cell-required disableifapproved" type="text" name="sap_po_no" id="sap_po_no" value="<?= old("sap_po_no", esc($greencoffee->sap_po_no)) ?>" required>
                    </p>
                    <p class="s2" style="padding-top: 2pt;padding-left: 5pt;text-indent: 0pt;text-align: left;">
                        Delivery Note No:
                        <input class="grid-cell cell-required disableifapproved" type="text" name="delivery_note_no" id="delivery_note_no" value="<?= old("delivery_note_no", esc($greencoffee->delivery_note_no)) ?>" required>
                    </p>
                </div>
                <div style="grid-column:3;">
                    <div style="display:grid; grid-template-columns:repeat(2,128px);">
                        <div class="s2" style="grid-column: 1; grid-row:1; padding: 0 20px;">
                            Delivery Date:
                        </div>
                        <div style="grid-column:2; grid-row:1;">
                            <input class="s2 grid-cell cell-required disableifapproved" type="date" name="delivery_date" id="delivery_date" value="<?= old("delivery_date", date_format(date_create($greencoffee->delivery_date), 'Y-m-d')) ?>" required>
                        </div>

                    </div>
                </div>
            </div>

            <div class="green-coffee-inspection">
                <div style="grid-column:1; grid-row:1;">
                    <p class="s2" style="padding-left: 11pt;text-indent: 0pt;text-align: left;">Moisture Level</p>
                    <p style="padding-left: 11pt;text-indent: 0pt;text-align: left;">(Target: 10-12%)</p>
                </div>

                <div style="grid-column:1; grid-row:2;">
                    <p class="s2" style="padding-left: 11pt;text-indent: 0pt;text-align: left;">Visual Check</p>
                    <p style="padding-left: 11pt;text-indent: 0pt;text-align: left;">(Defects, Inconsistencies, Foreign Matter)</p>
                </div>
                <div style="grid-column:1; grid-row:3;">
                    <p class="s2" style="padding-left: 11pt;text-indent: 0pt;text-align: left;">Smell Check</p>
                    <p style="padding-left: 11pt;text-indent: 0pt;text-align: left;">(Fresh, No Off-Odors)</p>
                </div>

                <div style="grid-column:2; grid-row:1;">
                    <input class="grid-cell s3 disableifapproved" style="width:5rem;" type="number" name="moisture_level" id="moisture_level" value="<?= old("moisture_level", esc($greencoffee->moisture_level)) ?>">
                </div>

                <div style="grid-column:2; grid-row:2;padding-top:20px;">
                    <div style="padding:0; display:grid; justify-content: left;  align-content: center; grid-template-columns:repeat(4,auto); gap: 4px; grid-auto-flow: column;">
                        <div class="s3">Pass</div>
                        <div>
                            <input class="disableifapproved" type="radio" name="visual_check" id="visual-check-pass" <?= $greencoffee->visual_check == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('visual_check', 1) ?>>
                        </div>
                        <div class="s3">Fail</div>
                        <div>
                            <input class="disableifapproved" type="radio" name="visual_check" id="visual-check-fail" <?= $greencoffee->visual_check == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('visual_check', 0) ?>>
                        </div>
                    </div>
                </div>
                <div style="grid-column:2; grid-row:3;padding-top:20px;">
                    <div style="padding:0; display:grid; justify-content: left;  align-content: center; grid-template-columns:repeat(4,auto); gap: 4px; grid-auto-flow: column;">
                        <div class="s3">
                            Pass
                        </div>
                        <div>
                            <input class="grid-cell-checkbox disableifapproved" type="radio" name="smell_check" id="smell-check-pass" <?= $greencoffee->smell_check == '1' ? "checked='checked'" : "" ?> value="1" <?= set_radio('smell_check', 1) ?>>
                        </div>
                        <div class="s3">
                            Fail
                        </div>
                        <div>
                            <input class="grid-cell-checkbox disableifapproved" type="radio" name="smell_check" id="smell-check-fail" <?= $greencoffee->smell_check == '0' ? "checked='checked'" : "" ?> value="" <?= set_radio('smell_check', 0) ?>>
                        </div>
                    </div>
                </div>

                <div style="grid-column:1 / SPAN 2;grid-row:4;">
                    <p class="s2" style="padding-left: 11pt;text-indent: 0pt;text-align: left;">Comments:</p>
                    <div style="grid-column: 1 / SPAN 2; grid-row:5;">
                        <textarea class="grid-cell s3 disableifapproved" name="coffee_comments" id="coffee_comments" rows="10" ><?= old("coffee_comments", esc($greencoffee->coffee_comments)) ?></textarea>
                    </div>
                </div>
            </div>

            <div class="final-approval">
                <!-- 5 columns -->

                <div style="grid-column: 2; grid-row: 1;">
                    <p class="s2">Approval by:</p>
                </div>
                <div style="grid-column: 3; grid-row: 1;">
                    <?= $approved_by ?>
                </div>
            </div>
            <button id="submit_btn" class="button grid-cell disableifapproved" type="submit">Save</button>
            <a href="<?= url_to('GreenCoffees::index') ?>" class="button grid-cell" style="background-color: darkred;">Cancel</a>
        </div>
    </div>
</main>

