<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Countries<?= $this->endSection() ?>
<?= $this->section("content") ?>

<?= view(
	"layouts/bcr-nav",
	[
		"title" => "Countries",
		"controller" => "Countries",
		"links" => [
			"New" =>  ["url" => url_to("Countries::new"), "auth_check" => true]
		]
	]
) ?>

<div class="index-div">
	<table>
		<tr>
			<th></th>
			<th>ID</th>
			<th>Country</th>
			<th>Last Updated</th>
			<th>Updated By</th>

			<?php
			foreach ($countries as $country) : ?>
		<tr>
			<td>
				<a href="<?= site_url('/countries/' . $country->CountryID) ?>">
					<button>View</button>
				</a>
			</td>
			<td>
				<?= $country->CountryID ?>
			</td>
			<td>
				<?= esc($country->Country) ?>
			</td>
			<td>
				<?= $country->lastupdated ?>
			</td>
			<td>
				<?= esc($country->username) ?>
			</td>
		</tr>
	<?php
			endforeach; ?>


	</table>
</div>
<?= $this->endSection() ?>