<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Inputs<?= $this->endSection() ?>

<?= $this->section("header") ?>
<link rel="stylesheet" href="<?= base_url('css/coffeedemand.css').'?'.rand() ?>" />
<?= $this->endSection() ?>

<?= $this->section("content") ?>
<a class="button" href="<?= site_url('/coffeedemand').'/'. $inputtypeid .'/export' ?>">Export</a>
<div class="coffeedemand-heading"><?= ucwords(strtolower($inputtype->InputType)) ?> Demand</div>

<?php 
    $recipe = key($demands);
    $coffees  = $demands[$recipe];
    //dd($demands);

    $rows = count($demands);
    if($rows > 0 ){
         $cols = count($demands[key($demands)]);
    };
?>

<div class="coffeedemand-main" 
style="display: grid; gap:1em; grid-template-columns:200px repeat(<?=$cols?>,100px);"
>
<?php 
    $recipe = key($demands);
    $coffees  = $demands[$recipe];
    $inputids = $demands["InputIDs"];
    echo '<div></div>';
    for ($i=0; $i < $cols; $i++) { 
        $coffee = key($coffees);
        $inputid = $inputids[$i];
//        echo '<div class="coffeedemand-col-header">'.$coffee.'</div>';
        echo "<div class='coffeedemand-col-header'><a href='".site_url('/inputs')."/$inputid'>$coffee</a></div>";
        next($coffees);
    }; 
    $recipeids = $demands["RecipeIDs"]; 
    $j = 0;
    foreach ($demands as $demand){
        $recipe = key($demands);
        //echo $recipe;
//        dd($demand);
        if($recipe != 'InputIDs' && $recipe != 'RecipeIDs'){
            if($recipe != 'Totals'){
                $recipeid = $recipeids[$j];
                $j++;
                echo "<div class='coffeedemand-recipe-cell'><a href='".site_url('/recipes')."/$recipeid'>$recipe</a></div>";
            }else{
                echo "<div class='coffeedemand-recipe-cell'>$recipe</div>";
            }
            $coffees = $demands[$recipe]; 
            //echo key($coffees).'<br/>';
            //echo '<br/>';
            for ($i=0; $i < $cols; $i++) { 
                $demand = number_format($coffees[key($coffees)],0);
                if($recipe === 'Totals'){
                    echo '<div class="coffeedemand-totals-cell">'.$demand.'</div>';
                }else{
                    echo '<div class="coffeedemand-cell">'.$demand.'</div>';
                }
                next($coffees);
            }
        }
        next($demands);
    }
?>
</div>

<?= $this->endSection() ?>

<?= $this->section("javascript") ?>
<?= $this->endSection() ?>

