<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Categories<?= $this->endSection() ?>
<?= $this->section("content") ?>


<?= view("layouts/bcr-nav",
    [
        "title" => "Categories",
        "controller" => "Categories",
        "links" => [
            "New" =>  ["url" => url_to("Categories::new"), "auth_check" => true]
        ]
    ]
) ?>


<div class="index-div">

    <table>
        <tr>
            <th></th>
            <th>ID</th>
            <th>Category</th>
            <th>Discount 1</th>
            <th>Discount 2</th>
            <th>Discount 3</th>
            <th>Header Colour</th>
            <th>Body Colour</th>
            <th>Footer Colour</th>
            <th>Last Updated</th>
            <th>Updated By</th>

            <?php foreach ($categories as $category): ?>
        <tr>
            <td>
                <a href="<?= site_url('/categories/' . $category->CategoryID) ?>">
                    <button>View</button>
                </a>
            </td>
            <td>
                <?= $category->CategoryID ?>
            </td>
            <td>
                <?= esc($category->Category) ?>
            </td>
            <td>
                <?= $category->Discount1 ?>
            </td>
            <td>
                <?= $category->Discount2 ?>
            </td>
            <td>
                <?= $category->Discount3 ?>
            </td>
            <td>
                <div style="background-color: <?= $category->HeaderColour ?>; width: 20px; height: 20px;"></div>
            </td>
            <td>
                <div style="background-color: <?= $category->BodyColour ?>; width: 20px; height: 20px;"></div>

            </td>
            <td>
                <div style="background-color: <?= $category->FooterColour ?>; width: 20px; height: 20px;"></div>

            </td>
            <td>
                <?= $category->lastupdated ?>
            </td>
            <td>
                <?= esc($category->username) ?>
            </td>
        </tr>
    <?php endforeach; ?>


    </table>
</div>
<?= $this->endSection() ?>