<?= $this->extend("layouts/default") ?>
<?= $this->section("title") ?>Settings<?= $this->endSection() ?>

<?= $this->section("header") ?>

<!-- <link rel="stylesheet" href="<?= base_url('/css/imagecarousel.css') . '?' . rand() ?>" /> -->

<link rel="stylesheet" href="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.css') ?>" />
<link rel="stylesheet" href="<?= base_url('/js/tabulator-master/dist/css/tabulator_simple.css') ?>" />

<link rel="stylesheet" href="<?= base_url('/js/daypilot-modal-confirm/themes/modal_rounded.css'); ?>" type="text/css">
<link href="<?= base_url('js/lightbox2/dist/css/lightbox.css') ?>" rel="stylesheet" />


<script type='text/javascript' src="<?= base_url('/js/jquery/jquery-3.7.1.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/jquery-ui-1.14.1/jquery-ui.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/luxon.min.js') ?>"> </script>
<script type='text/javascript' src="<?= base_url('/js/tabulator-master/dist/js/tabulator.min.js') ?>"> </script>


<script type='text/javascript' src="<?= base_url('js/htmx/htmx.min.js') ?>"></script>
<script type='text/javascript' src="<?= base_url('/js/daypilot-modal-confirm/js/daypilot-modal-3.15.1.min.js'); ?>"></script>

<style>
	.tabulator-row.tabulator-selectable:hover {
		background-color: #bbb !important;
	}
</style>
<?= $this->endSection() ?>

<?= $this->section("content") ?>


<?= view(
    "layouts/bcr-nav",
    [
        "title" => "Settings",
        "controller" => "Allsettings",
        "links" => []
    ]
) ?>


    <div style="margin:25px; border-style:solid; border-width: thin; border-radius: 5px; padding:5px;">

<h1>System Images</h1>

<?php if (session()->has("uploaderrors")): ?>
    <ul>
        <?php foreach (session()->get("uploaderrors") as $error): ?>
            <li style="color: red;"><?= $error ?></li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>


<div style="display:grid; gap: 5px; grid-template-columns: repeat(6, 1fr);align-content: center;">

<?php foreach ($images as $usedfor => $img): ?>

	<div style="border-style: solid; border-width: 3px; border-color: #213242; border-radius: 5px;padding:10px;">
		<div style="text-align: center;">
			<h1><?= $img['ImageTitle']?></h1>
		</div>

			<?php if($img['ImageName'] == ''): ?>
				<img class="example-image" src="<?= site_url('images/image-not-found.png'); ?>" alt="Image Not Found" style="max-width:10vw; max-height:10vw;">
			<?php else: ?>
				<a href="<?= $img['ImageName'] ?>" data-lightbox="pack-image" data-title=".">
				<img class="example-image" src="<?= $img['ImageName'] ?>" alt="<?= $img['ImageTitle'] ?>" style="max-width:10vw; max-height:10vw;">
			<?php endif; ?>
		</a>

		<div style="text-align: center;">
			<?php if($img['ImageName'] != ''): ?>
				<a id="<?= $img['ImageID'] ?>" class="button" onclick="delete_image_click(this.id);">Delete</a>
			<?php endif; ?>
		</div>

		<div style="margin-top: 20px;">
			<?= form_open_multipart("allsettings/uploadimage") ?>
			<div style="display:grid;">
				<div>
					<h2>Upload New Image</h2>
				</div>
				<div>
					<input type="hidden" id="usedfor" name="usedfor" value="<?= $usedfor ?>">

					<input class="bvr-blue-text" type="file" name="userfile" size="20">
				</div>
				<div>
					<input class="button" type="submit" value="upload">
				</div>
			</div>
			</form>
		</div>
	</div>

<?php endforeach; ?>
</div>
</div>

<?= $this->endSection() ?>

<?= $this->section("javascript") ?>

<div id="res"></div>

<input type="hidden" id="csrfcode" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">

<?= view("layouts/tabulatorgrid") ?>

<script type='text/javascript'>
	//$rowHoverBackground = #ffffff;

	var table1 = new Tabulator('#wrapper', {
		rowFormatter: function(row) {
			//row - row component

			var data = row.getData();
			var style = row.getElement().style;
			//if (data.AnnualKg > 0) {
			row.getElement().style.backgroundColor = data.BodyColour; //  "#76EE00";
			//row.getElement().style.Selection = data.HeaderColour; //  "#76EE00";
			row.getElement().style.color = "#000000"; //  "#76EE00";
			//}
		},
		data: [
			<?php foreach ($sysvars as $sysvar): ?>
				<?= "{" ?>
				<?= "SysVarID:$sysvar->SysVarID," ?>
				<?= "KeyName:'" . addslashes($sysvar->KeyName) . "'," ?>
				<?= "ValueText:'" . addslashes($sysvar->ValueText) . "'," ?>
				<?= "}," ?>
				<?= chr(13) . chr(10) ?>
			<?php endforeach; ?>
		],
		layout: "fitDataStretch",
		pagination: false,
		//height:"100%",
		//paginationSize: 25,
		tooltips: true,
		//maxHeight:"100vh",
		//editTriggerEvent:"click",
		columns: [{
			title: "SysVarID",
			field: "SysVarID",
			sorter: "number",
			width: 150,
			visible: false,
		}, {
			title: "Key Name",
			field: "KeyName",
			sorter: "string",
			hozAlign: "left",
			width: 200,
			headerFilter: "input",
		}, {
			title: "Value Text",
			field: "ValueText",
			sorter: "string",
			hozAlign: "left",
			width: 170,
			headerFilter: "input",
			editor:"input",
		}, ],
	});

	table1.on('cellClick', function(e, cell) {
		//alert(cell.getColumn().getField());
		//            if(cell.getColumn().getField() != 'AnnualKg'){
		//alert(cell.getRow().getCell('RecipeID').getValue());
		//window.location = '<?= base_url("recipes") . "/" ?>' + cell.getRow().getCell('RecipeID').getValue();
		//            }
		//window.location = '<?= base_url("recipes") . "/" ?>' + row.getCell('RecipeID').getValue();
	});
	table1.on("cellEdited", function(cell){
		var keyname;
		var valuetext;
        var row = cell.getRow();
		var col = cell.getColumn();
		if(col.getField()=='ValueText'){
			valuetext = cell.getValue();
			var keycol = col.getPrevColumn();
			keyname =  row.getCell(keycol).getValue();
		}
		if(col.getField()=='KeyName'){
			keyname = cell.getValue();
			valcol = col.getNextColumn();
			valuetext = row.getCell(valcol).getValue();
		}
		//alert(keyname+'='+valuetext);
		let csrfField = document.getElementById('csrfcode');
		let csrfname = csrfField.name;
		let csrfval = csrfField.value;

		let vals = {};
		vals['KeyName'] = keyname;
		vals['ValueText'] = valuetext;
		vals[csrfname] = csrfval;

		htmx.ajax('POST',
            "<?= base_url('allsettings') ?>", {
                target: "#res",
                swap: 'none',
                handler: (_, response) => {
                    restext = response.xhr.responseText;
                    console.log(response.xhr.responseText);
                    var res = JSON.parse(restext);
					console.log(res.comment);
					$('#csrfcode').val(res.token);
                },
                values: vals,
            }
        );
	});
</script>

<?= $this->endSection() ?>

<?= $this->section("javascript") ?>

<script src="<?= base_url('js/lightbox2/dist/js/lightbox.js') ?>"></script>

<script type='text/javascript'>
    function delete_image_click(id) {
        DayPilot.Modal.confirm("Do you want to DELETE this Image?", {
            theme: "modal_rounded"
        }).then(function(args) {
            if (args.result) {
                window.location = '<?=base_url("allsettings")?>'+'/'+id+'/imagedelete';
            }
        });
    }
</script>

<?= $this->endSection() ?>