<?php

namespace App\Models;

use CodeIgniter\Model;

class User_accessModel extends Model
{
    protected $table = "user_access";
    
    protected $primaryKey = 'uaid';

    protected $allowedFields = ["uid", "ualid", "can_access", "can_edit"];

    protected $returnType = \App\Entities\User_access::class;

    protected $validationRules = [
        "uid" => "required",
        "ualid" => "required",
    ];

    protected $validationMessages = [
        "uid" => [
            "required" => "Please enter a user",
        ],
        "ualid" => [
            "required" => "Please enter a access area",
        ]
    ];
    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}