<?php

namespace App\Models;

use CodeIgniter\Model;

class TemplatesModel extends Model
{
    protected $table = "templates";
    
    protected $primaryKey = 'TemplateID';

    protected $allowedFields = ["TemplateName","Notes","users_id"];

    protected $returnType = \App\Entities\Template::class;

    protected $validationRules = [
        "TemplateName" => "required|max_length[255]|is_unique[templates.TemplateName]"
    ];

    protected $validationMessages = [
        "TemplateName" => [
            "required" => "Please enter a Template Name",
            "max_length" => "{param} characters maximum for the Template",
            "is_unique" => "Template '{value}' already exists"
        ]
    ];
    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}