<?php

namespace App\Models;

use CodeIgniter\Model;

class TemplateInputsModel extends Model
{
    protected $table = "templateinputs";
    
    protected $primaryKey = 'TemplateInputID';

    protected $allowedFields = ["TemplateID","InputID","Qty"];

    protected $returnType = \App\Entities\TemplateInput::class;

    protected $validationRules = [
        "TemplateID" => "required|greater_than[0.0]",
        "InputID" => "required|greater_than[0.0]",
        "Qty" => "required|greater_than[0.0]",
    ];

    protected $validationMessages = [
        "TemplateID" => [
            "required" => "Please Select a Template",
            "greater_than" => "Template ID must be greater than 0"
        ],
        "InputID" => [
            "required" => "Please Select an input",
            "greater_than" => "Input ID must be greater than 0"
        ],
        "Qty" => [
            "required" => "Please enter a Qty greater than 0",
            "greater_than" => "Please enter a Qty greater than 0"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}