<?php

namespace App\Models;

use CodeIgniter\Model;

class SystemImagesModel extends Model
{
    protected $table = "system_images";

    protected $primaryKey = 'ImageID';

    protected $allowedFields = ["ImageName", "ImageTitle", "UsedFor"];

    protected $returnType = \App\Entities\SystemImage::class;

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}