<?php

namespace App\Models;

use CodeIgniter\Model;

class SysVarsModel extends Model
{
    protected $table = "sysvars";
    
    protected $primaryKey = 'SysVarID';

    protected $allowedFields = ["KeyName", "ValueText"];

    protected $returnType = \App\Entities\SysVar::class;

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}