<?php

namespace App\Models;

use CodeIgniter\Model;

class SuppliersModel extends Model
{
    protected $table = "suppliers";
    
    protected $primaryKey = 'SupplierID';

    protected $allowedFields = ["Supplier"];

    protected $returnType = \App\Entities\Supplier::class;

    protected $validationRules = [
        "Supplier" => "required|max_length[255]|is_unique[suppliers.Supplier]"
    ];

    protected $validationMessages = [
        "Supplier" => [
            "required" => "Please enter a Supplier",
            "max_length" => "{param} characters maximum for the Supplier",
            "is_unique" => "Supplier '{value}' already exists"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];
    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}