<?php

namespace App\Models;

use CodeIgniter\Model;

class RoastLevelsModel extends Model
{
    protected $table = "roastlevels";
    
    protected $primaryKey = 'RoastLevelID';

    protected $allowedFields = ["RoastLevel"];

    protected $returnType = \App\Entities\RoastLevel::class;
    
    protected $validationRules = [
        "RoastLevel" => "required|max_length[255]|is_unique[roastlevels.RoastLevel]"
    ];

    protected $validationMessages = [
        "RoastLevel" => [
            "required" => "Please enter a Roast Level",
            "max_length" => "{param} characters maximum for the Roast Level",
            "is_unique" => "Roast Level '{value}' already exists"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];
    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}