<?php

namespace App\Models;

use CodeIgniter\Model;

class RoastColoursModel extends Model
{
    protected $table = "roastcolours";
    
    protected $primaryKey = 'RoastColourID';

    protected $allowedFields = ["FromNumber", "ToNumber", "RoastColourName"];

    protected $returnType = \App\Entities\RoastColour::class;

    protected $validationRules = [
        "RoastColourName" => "required|max_length[50]|is_unique[roastcolours.RoastColourName]",
        "FromNumber" => "required|greater_than_equal_to[0]",
        "ToNumber" => "required|greater_than_equal_to[0]",
    ];

    protected $validationMessages = [
        "RoastColourName" => [
            "required" => "Please enter a Roast Colour Name",
            "max_length" => "{param} characters maximum for the Roast Colour Name",
            "is_unique" => "Roast Colour Name '{value}' already exists - must be unique"
        ],
        "FromNumber" => [
            "required" => "Please enter lowest Roast Colour Number for this Name",
            "greater_than_equal_to" => "Must be greater than 0",
        ],
        "ToNumber" => [
            "required" => "Please enter highest Roast Colour Number for this name",
            "greater_than_equal_to" => "Must be greater than 0",
        ],

    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }
}