<?php

namespace App\Models;

use CodeIgniter\Model;

class RecipesModel extends Model
{
    protected $table = "recipes";

    protected $primaryKey = 'RecipeID';

    protected $allowedFields = ["RecipeName","RecipeCode","CategoryID","PackQty","WastePercent","AnnualKg",
    "ValidFromDate","NextValidFromDate", "Notes","users_id","Description",
    "TotalCost","NextTotalCost",
    "SellPriceKg","NextSellPriceKg",
    "lastupdated",
    "OuterSize","RoastLevelID", "storage_location", "RoastColourNo", "RoastColourID", "ImageID","SellPriceGP","NextSellPriceGP"];

    protected $returnType = \App\Entities\Recipe::class;

    protected $validationRules = [
        "RecipeName" => "required|max_length[255]|is_unique[recipes.RecipeName]",
        "PackQty" => "required|greater_than[0.0]",
        "CategoryID" => "required|greater_than[0]"
    ];

    protected $validationMessages = [
        "RecipeName" => [
            "required" => "Please enter an Recipe Name",
            "max_length" => "{param} characters maximum for the Recipe Name",
            "is_unique" => "Recipe Name '{value}' already exists"
        ],
        "PackQty" => [
            "required" => "Please enter a Finished Weight",
            "greater_than" => "Finished Weight must be greater than 0"
        ],
        "CategoryID" => [
            "required" => "Please select a Category",
            "greater_than" => "Please select a Category"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}