<?php

namespace App\Models;

use CodeIgniter\Model;

class RecipeInputsModel extends Model
{
    protected $table = "recipeinputs";
    
    protected $primaryKey = 'RecipeInputID';

    protected $allowedFields = ["RecipeID","InputID","Qty"];

    protected $returnType = \App\Entities\RecipeInput::class;
    
    protected $validationRules = [
        "RecipeID" => "required|greater_than[0.0]",
        "InputID" => "required|greater_than[0.0]",
        "Qty" => "required|greater_than[0.0]",
    ];

    protected $validationMessages = [
        "RecipeID" => [
            "required" => "Please Select a recipe",
            "greater_than" => "Recipe ID must be greater than 0"
        ],
        "InputID" => [
            "required" => "Please Select an input",
            "greater_than" => "Input ID must be greater than 0"
        ],
        "Qty" => [
            "required" => "Please enter a Qty greater than 0",
            "greater_than" => "Please enter a Qty greater than 0"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}