<?php

namespace App\Models;

use CodeIgniter\Model;

class RecipeImagesModel extends Model
{
    protected $table = "recipe_images";
    
    protected $primaryKey = 'ImageID';

    protected $allowedFields = ["RecipeID", "ImageName"];

    protected $returnType = \App\Entities\RecipeImage::class;

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}