<?php

namespace App\Models;

use CodeIgniter\Model;

class ProductionModel extends Model
{
    protected $table = "production";

    protected $primaryKey = 'ProductionID';

    protected $allowedFields = ["ProductionID", "coffee_name", "batch_number",
        "certification_na", "certification_fairtrade", "certification_rfa",
        "certification_organic", "check_date", "checked_by", "qty_requested",
        "qty_produced", "green_coffee1", "green_coffee2", "green_coffee3",
        "green_coffee4", "green_coffee5", "qty_used1", "qty_used2", "qty_used3",
        "qty_used4", "qty_used5", "moisture_level1", "moisture_level2", "moisture_level3",
        "moisture_level4", "moisture_level5", "rfa1", "organic1", "fairtrade1", "na1",
        "rfa2", "organic2", "fairtrade2", "na2", "rfa3", "organic3", "fairtrade3", "na3",
        "rfa4", "organic4", "fairtrade4", "na4", "rfa5", "organic5", "fairtrade5", "na5",
        "visual_check1", "visual_check2", "visual_check3", "visual_check4",
        "visual_check5", "smell_check1", "smell_check2", "smell_check3",
        "smell_check4", "smell_check5", "green_coffee_comments", "diedrich_cr35",
        "joper_120", "profile_used", "end_temp_target", "actual_temp",
        "first_crack_timing", "roastcolourno", "colour_analysis", "bean_apperance", "moisture_level_after_roasting",
        "post_roast_comments", "cupping_conducted", "cupped_by", "fragrance",
        "flavour", "aftertaste", "acidity", "body", "clean_cup", "sweetness",
        "quality_check_1", "quality_check_2", "quality_check_3",
        "quality_check_4", "quality_check_5", "weight_accuracy_1", "weight_accuracy_2",
        "weight_accuracy_3", "weight_accuracy_4", "weight_accuracy_5", "grind_size",
        "packaging_qc_by", "batch_approved", "final_qc_approval", "final_comments", "action_taken_adjust",
        "action_taken_blend", "action_taken_reject", "time_completed", "users_id","storage_location",
        "weight_batch_code","weight_pack",
        "weight_1","weight_2","weight_3","weight_4","weight_5","weight_6","weight_7","weight_8","weight_9","weight_10","weight_end",
        "weight_operator","weight_leader",
        "operator_approval","teamleader_approval"
    ];

    protected $returnType = \App\Entities\ProductionEntity::class;

    // protected $validationRules = [
    //     "Category" => "required|max_length[255]|is_unique[categories.Category]"
    // ];

    // protected $validationMessages = [
    //     "Category" => [
    //         "required" => "Please enter a Category",
    //         "max_length" => "{param} characters maximum for the Category",
    //         "is_unique" => "Category '{value}' already exists"
    //     ]
    // ];
    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}
