<?php

namespace App\Models;

use CodeIgniter\Model;

class ProductionCertificationsModel extends Model
{
    protected $table = "production_certifications";
    
    protected $primaryKey = 'ProductionCertificationID';

    protected $allowedFields = ["ProductionID", "CertificationID", "CheckboxName", "CheckboxValue"];

    protected array $casts =["ProductionCertificationID"=>"int", "ProductionID"=>"int", "CertificationID"=>"int", "CheckboxValue"=>"int"];

    protected $returnType = \App\Entities\ProductionCertification::class;

    // protected $validationRules = [
    //     "Category" => "required|max_length[255]|is_unique[categories.Category]"
    // ];

    // protected $validationMessages = [
    //     "Category" => [
    //         "required" => "Please enter a Category",
    //         "max_length" => "{param} characters maximum for the Category",
    //         "is_unique" => "Category '{value}' already exists"
    //     ]
    // ];
    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}