<?php

namespace App\Models;

use CodeIgniter\Model;

class ProcessesModel extends Model
{
    protected $table = "processes";
    
    protected $primaryKey = 'ProcessID';

    protected $allowedFields = ["Process"];

    protected $returnType = \App\Entities\Process::class;

    protected $validationRules = [
        "Process" => "required|max_length[255]|is_unique[processes.Process]"
    ];

    protected $validationMessages = [
        "Process" => [
            "required" => "Please enter a Process",
            "max_length" => "{param} characters maximum for the Process",
            "is_unique" => "Process '{value}' already exists"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}