<?php

namespace App\Models;

use CodeIgniter\Model;

class InputsModel extends Model
{
    protected $table = "inputs";
    
    protected $primaryKey = 'InputID';

    protected $allowedFields = ["InputName","InputCode","SupplierID",
        "CountryID","ProcessID","CertificationID","Cost","ValidFromDate","NextCost","NextValidFromDate",
        "ConversionFactor","CostUpdated","CostPack","StockQty",
        "WastePercent",
        "LeftOnContract","InputTypeID","Notes"];

    protected $returnType = \App\Entities\Input::class;
    
    protected $validationRules = [
        "InputName" => "required|max_length[255]|is_unique[inputs.InputName]",
        "ConversionFactor" => "required|greater_than[0.0]"
    ];

    protected $validationMessages = [
        "InputName" => [
            "required" => "Please enter an Input Name",
            "max_length" => "{param} characters maximum for the Input Name",
            "is_unique" => "Input Name '{value}' already exists"
        ],
        "ConversionFactor" => [
            "required" => "Please enter a Conversion factor",
            "greater_than" => "Conversion factor must be greater than 0"
        ],
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}