<?php

namespace App\Models;

use CodeIgniter\Model;

class InputTypesModel extends Model
{
    protected $table = "inputtypes";
    
    protected $primaryKey = 'InputTypeID';

    protected $allowedFields = ["InputType","DisplayOrder","IsCoffee"];

    protected $returnType = \App\Entities\InputType::class;

    protected $validationRules = [
        "InputType" => "required|max_length[50]|is_unique[inputtypes.InputType]",
        "DisplayOrder" => "required|is_unique[inputtypes.DisplayOrder]",
        "IsCoffee" => "required"
    ];

    protected $validationMessages = [
        "InputType" => [
            "required" => "Please enter an Input Type",
            "max_length" => "{param} characters maximum for the Input Type",
            "is_unique" => "Input Type '{value}' already exists"
        ],
        "DisplayOrder" => [
            "required" => "Please enter Display order",
            "is_unique" => "Display Order '{value}' already exists"
        ],
        "IsCoffee" => [
            "required" => "Please whether input type is cofee or not",
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}