<?php

namespace App\Models;

use CodeIgniter\Model;

class InputCostsModel extends Model
{
    protected $table = "inputcosts";
    
    protected $primaryKey = 'InputCostID';

    protected $allowedFields = [
        "InputID",
        "Cost",
        "Notes",
        "ValidFromDate",
        "users_id"
    ];

    //protected array $casts =["InputCostID"=>"int", "InputID"=>"int", "id"=>"int"];

    protected $returnType = \App\Entities\InputCost::class;
    
    protected $validationRules = [
        //'id' => 'required',
        'InputID' => 'required',
        'Cost' => 'required',
        //'ValidFromDate' => 'required|is_unique[inputcosts.ValidFromDate, inputcosts.InputID, {id}]'
    ];


// protected $validationRules = [
//         'id'    => 'max_length[19]|is_natural_no_zero',
//         'email' => 'required|max_length[254]|valid_email|is_unique[users.email,id,{id}]',
//     ];
//]|is_unique[organisaties.organisatie_naam,organisaties.id,' . $id.']',

    protected $validationMessages = [
        "InputID" => [
            "required" => "Please enter an InputID",
        ],
        "Cost" => [
            "required" => "Please enter a Price/Kg",
        ],
        // "ValidFromDate" => [
        //     "required" => "Please enter the date the price is valid from",
        //     "is_unique" => "The date, '{value}' already exists for {id}."
        // ],
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}