<?php

namespace App\Models;

use CodeIgniter\Model;

class GreenCoffeesModel extends Model
{
    protected $table = "greencoffees";
    
    protected $primaryKey = 'GreenCoffeeID';

    protected $allowedFields = [
    "coffee_name",
    "sap_po_no",
    "delivery_note_no",
    "delivery_date",
    "moisture_level",
    "visual_check",
    "smell_check",
    "approved_by",
    "date_approved",
    "coffee_comments",
    "deleted",
    "users_id"
    ];

    protected $returnType = \App\Entities\GreenCoffeeEntity::class;

    // protected $validationRules = [
    //     "Category" => "required|max_length[255]|is_unique[categories.Category]"
    // ];

    // protected $validationMessages = [
    //     "Category" => [
    //         "required" => "Please enter a Category",
    //         "max_length" => "{param} characters maximum for the Category",
    //         "is_unique" => "Category '{value}' already exists"
    //     ]
    // ];
    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}