<?php

namespace App\Models;

use CodeIgniter\Model;

class CountriesModel extends Model
{
    protected $table = "countries";
    
    protected $primaryKey = 'CountryID';

    protected $allowedFields = ["Country"];

    protected $returnType = \App\Entities\Country::class;

    protected $validationRules = [
        "Country" => "required|max_length[255]|is_unique[countries.Country]"
    ];

    protected $validationMessages = [
        "Country" => [
            "required" => "Please enter a Country",
            "max_length" => "{param} characters maximum for the Country",
            "is_unique" => "Country '{value}' already exists"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}