<?php

namespace App\Models;

use CodeIgniter\Model;

class CertificationsModel extends Model
{
    protected $table = "certifications";
    
    protected $primaryKey = 'CertificationID';

    protected $allowedFields = ["Certification"];

    protected $returnType = \App\Entities\Certification::class;

    protected $validationRules = [
        "Certification" => "required|max_length[255]|is_unique[certifications.Certification]"
    ];

    protected $validationMessages = [
        "Certification" => [
            "required" => "Please enter a Certification",
            "max_length" => "{param} characters maximum for the Certification",
            "is_unique" => "Certification '{value}' already exists"
        ]
    ];

    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }
}