<?php

namespace App\Models;

use CodeIgniter\Model;

class CategoriesModel extends Model
{
    protected $table = "categories";
    
    protected $primaryKey = 'CategoryID';

    protected $allowedFields = ["Category", "HeaderColour", "BodyColour", "FooterColour", "Discount1", "Discount2", "Discount3"];

    protected $returnType = \App\Entities\Category::class;

    protected $validationRules = [
        "Category" => "required|max_length[255]|is_unique[categories.Category]"
    ];

    protected $validationMessages = [
        "Category" => [
            "required" => "Please enter a Category",
            "max_length" => "{param} characters maximum for the Category",
            "is_unique" => "Category '{value}' already exists"
        ]
    ];
    protected $beforeInsert = ["setUsersID"];
    protected $beforeUpdate = ["setUsersID"];

    protected function setUsersID(array $data)
    {
        $data["data"]["users_id"] = auth()->user()->id;

        return $data;

    }

}